///////////////////////////////////////////////////////////////////////////////
//                                                                            /
//                                                      26/May/2011  14:36:15 /
// IAR ANSI C/C++ Compiler V5.20.0.20892/W32 EVALUATION for ARM               /
// Copyright 1999-2008 IAR Systems AB.                                        /
//                                                                            /
//    Cpu mode     =  thumb                                                   /
//    Endian       =  little                                                  /
//    Source file  =  E:\Mini-DS\DS203\APP_V2.41\source\dosfs.c               /
//    Command line =  E:\Mini-DS\DS203\APP_V2.41\source\dosfs.c -lA           /
//                    E:\Mini-DS\DS203\APP_V2.41\IAR_V5_Prpject\List\ -o      /
//                    E:\Mini-DS\DS203\APP_V2.41\IAR_V5_Prpject\Obj\ --debug  /
//                    --endian=little --cpu=Cortex-M3 --fpu=None              /
//                    --dlib_config "C:\Program Files\IAR Systems\Embedded    /
//                    Workbench 5.0 Evaluation\ARM\INC\DLib_Config_Full.h"    /
//                    -I E:\Mini-DS\DS203\APP_V2.41\IAR_V5_Prpject\..\..\FWLi /
//                    b\inc\ -I E:\Mini-DS\DS203\APP_V2.41\IAR_V5_Prpject\..\ /
//                    ..\USBLib\inc\ -I E:\Mini-DS\DS203\APP_V2.41\IAR_V5_Prp /
//                    ject\..\include\ -I "C:\Program Files\IAR               /
//                    Systems\Embedded Workbench 5.0 Evaluation\ARM\INC\"     /
//                    -Ohs                                                    /
//    List file    =  E:\Mini-DS\DS203\APP_V2.41\IAR_V5_Prpject\List\dosfs.s  /
//                                                                            /
//                                                                            /
///////////////////////////////////////////////////////////////////////////////

        NAME dosfs

        RTMODEL "__dlib_file_descriptor", "1"

        EXTERN __Disk_Buff_RD
        EXTERN __Disk_Buff_WR
        EXTERN __aeabi_memclr
        EXTERN __aeabi_memclr4
        EXTERN __aeabi_memcpy
        EXTERN __aeabi_memcpy4
        EXTERN __aeabi_memset
        EXTERN __aeabi_memset4
        EXTERN div
        EXTERN ldiv
        EXTERN memcmp
        EXTERN strcmp
        EXTERN strcpy
        EXTERN strlen
        EXTERN strncpy

        PUBLIC DFS_CanonicalToDir
        PUBLIC DFS_GetFAT
        PUBLIC DFS_GetFreeDirEnt
        PUBLIC DFS_GetFreeFAT
        PUBLIC DFS_GetNext
        PUBLIC DFS_GetPtnStart
        PUBLIC DFS_GetVolInfo
        PUBLIC DFS_OpenDir
        PUBLIC DFS_OpenFile
        PUBLIC DFS_ReadFile
        PUBLIC DFS_ReadSector
        PUBLIC DFS_Seek
        PUBLIC DFS_SetFAT
        PUBLIC DFS_UnlinkFile
        PUBLIC DFS_WriteFile
        PUBLIC DFS_WriteSector
        
        CFI Names cfiNames0
        CFI StackFrame CFA R13 DATA
        CFI Resource R0:32, R1:32, R2:32, R3:32, R4:32, R5:32, R6:32, R7:32
        CFI Resource R8:32, R9:32, R10:32, R11:32, R12:32, R13:32, R14:32
        CFI EndNames cfiNames0
        
        CFI Common cfiCommon0 Using cfiNames0
        CFI CodeAlign 2
        CFI DataAlign 4
        CFI ReturnAddress R14 CODE
        CFI CFA R13+0
        CFI R0 Undefined
        CFI R1 Undefined
        CFI R2 Undefined
        CFI R3 Undefined
        CFI R4 SameValue
        CFI R5 SameValue
        CFI R6 SameValue
        CFI R7 SameValue
        CFI R8 SameValue
        CFI R9 SameValue
        CFI R10 SameValue
        CFI R11 SameValue
        CFI R12 Undefined
        CFI R14 SameValue
        CFI EndCommon cfiCommon0
        
// E:\Mini-DS\DS203\APP_V2.41\source\dosfs.c
//    1 /*
//    2 	DOSFS Embedded FAT-Compatible Filesystem
//    3 	(C) 2005 Lewin A.R.W. Edwards (sysadm@zws.com)
//    4 
//    5 	You are permitted to modify and/or use this code in your own projects without
//    6 	payment of royalty, regardless of the license(s) you choose for those projects.
//    7 
//    8 	You cannot re-copyright or restrict use of the code as released by Lewin Edwards.
//    9 */
//   10 
//   11 #include <string.h>
//   12 #include <stdlib.h>
//   13 #include <stdio.h>
//   14 #include "BIOS.h"
//   15 #include "dosfs.h"
//   16 #include "stm32f10x_lib.h"
//   17 
//   18 #define DS203
//   19 
//   20 //===================================================================
//   21 // User-supplied functions

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock0 Using cfiCommon0
        CFI Function DFS_ReadSector
        THUMB
//   22 uint32_t DFS_ReadSector(uint8_t unit, uint8_t *buffer, uint32_t sector, uint32_t count)
//   23 {
DFS_ReadSector:
        PUSH     {LR}
        CFI R14 Frame(CFA, -4)
        CFI CFA R13+4
        SUB      SP,SP,#+4
        CFI CFA R13+8
        MOVS     R0,R1
        MOVS     R1,R2
//   24 		uint32_t add;
//   25 		add=sector<<9;
//   26 	__Disk_Buff_RD(buffer,add, SECTOR_SIZE);
        MOV      R2,#+512
        LSLS     R1,R1,#+9
        BL       __Disk_Buff_RD
//   27   return 0;
        MOVS     R0,#+0
        ADD      SP,SP,#+4
        CFI CFA R13+4
        POP      {PC}             ;; return
        CFI EndBlock cfiBlock0
//   28 }
//   29 

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock1 Using cfiCommon0
        CFI Function DFS_WriteSector
        THUMB
//   30 uint32_t DFS_WriteSector(uint8_t unit, uint8_t *buffer, uint32_t sector, uint32_t count)
//   31 {
DFS_WriteSector:
        PUSH     {R4,R5,LR}
        CFI R14 Frame(CFA, -4)
        CFI R5 Frame(CFA, -8)
        CFI R4 Frame(CFA, -12)
        CFI CFA R13+12
        SUB      SP,SP,#+4
        CFI CFA R13+16
        MOVS     R5,R1
//   32 	uint32_t add;
//   33 
//   34       add=sector*512; 
        LSLS     R4,R2,#+9
//   35       __Disk_Buff_WR(buffer, add);
        MOVS     R1,R4
        MOVS     R0,R5
        BL       __Disk_Buff_WR
//   36       __Disk_Buff_WR(&buffer[256], add+256);
        ADD      R1,R4,#+256
        ADD      R0,R5,#+256
        BL       __Disk_Buff_WR
//   37     	return 0;
        MOVS     R0,#+0
        ADD      SP,SP,#+4
        CFI CFA R13+12
        POP      {R4,R5,PC}       ;; return
        CFI EndBlock cfiBlock1
//   38 }
//   39 //===================================================================
//   40 /*
//   41 	Get starting sector# of specified partition on drive #unit
//   42 	NOTE: This code ASSUMES an MBR on the disk.
//   43 	scratchsector should point to a SECTOR_SIZE scratch area
//   44 	Returns 0xffffffff for any error.
//   45 	If pactive is non-NULL, this function also returns the partition active flag.
//   46 	If pptype is non-NULL, this function also returns the partition type.
//   47 	If psize is non-NULL, this function also returns the partition size.
//   48 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock2 Using cfiCommon0
        CFI Function DFS_GetPtnStart
        THUMB
//   49 uint32_t DFS_GetPtnStart(uint8_t unit, uint8_t *scratchsector, uint8_t pnum, uint8_t *pactive, uint8_t *pptype, uint32_t *psize)
//   50 {
DFS_GetPtnStart:
        PUSH     {R4-R8,LR}
        CFI R14 Frame(CFA, -4)
        CFI R8 Frame(CFA, -8)
        CFI R7 Frame(CFA, -12)
        CFI R6 Frame(CFA, -16)
        CFI R5 Frame(CFA, -20)
        CFI R4 Frame(CFA, -24)
        CFI CFA R13+24
        MOVS     R5,R1
        MOVS     R6,R2
        MOVS     R4,R3
        LDR      R7,[SP, #+24]
        LDR      R8,[SP, #+28]
//   51 	uint32_t result;
//   52 	PMBR mbr = (PMBR) scratchsector;
//   53 
//   54 	// DOS ptable supports maximum 4 partitions
//   55 	if (pnum > 3)
        CMP      R6,#+4
        BCC.N    ??DFS_GetPtnStart_0
//   56 		return DFS_ERRMISC;
        MOV      R0,#-1
        B.N      ??DFS_GetPtnStart_1
//   57 
//   58 	// Read MBR from target media
//   59 	if (DFS_ReadSector(unit,scratchsector,0,1)) {
??DFS_GetPtnStart_0:
        MOV      R2,#+512
        MOVS     R1,#+0
        MOVS     R0,R5
        BL       __Disk_Buff_RD
//   60 		return DFS_ERRMISC;
//   61 	}
//   62 
//   63 	result = (uint32_t) mbr->ptable[pnum].start_0 |
//   64 	  (((uint32_t) mbr->ptable[pnum].start_1) << 8) |
//   65 	  (((uint32_t) mbr->ptable[pnum].start_2) << 16) |
//   66 	  (((uint32_t) mbr->ptable[pnum].start_3) << 24);
        ADD      R1,R5,R6, LSL #+4
        ADD      R0,R1,#+454
        LDRB     R0,[R0, #+0]
        LDRB     R2,[R1, #+455]
        ORR      R0,R0,R2, LSL #+8
        LDRB     R2,[R1, #+456]
        ORR      R0,R0,R2, LSL #+16
        LDRB     R2,[R1, #+457]
        ORR      R0,R0,R2, LSL #+24
//   67 
//   68 	if (pactive)
        CBZ      R4,??DFS_GetPtnStart_2
//   69 		*pactive = mbr->ptable[pnum].active;
        ADD      R2,R1,#+446
        LDRB     R2,[R2, #+0]
        STRB     R2,[R4, #+0]
//   70 
//   71 	if (pptype)
??DFS_GetPtnStart_2:
        CBZ      R7,??DFS_GetPtnStart_3
//   72 		*pptype = mbr->ptable[pnum].type;
        ADD      R2,R1,#+450
        LDRB     R2,[R2, #+0]
        STRB     R2,[R7, #+0]
//   73 
//   74 	if (psize)
??DFS_GetPtnStart_3:
        CMP      R8,#+0
        BEQ.N    ??DFS_GetPtnStart_1
//   75 		*psize = (uint32_t) mbr->ptable[pnum].size_0 |
//   76 		  (((uint32_t) mbr->ptable[pnum].size_1) << 8) |
//   77 		  (((uint32_t) mbr->ptable[pnum].size_2) << 16) |
//   78 		  (((uint32_t) mbr->ptable[pnum].size_3) << 24);
        ADD      R2,R1,#+458
        LDRB     R2,[R2, #+0]
        LDRB     R3,[R1, #+459]
        ORR      R2,R2,R3, LSL #+8
        LDRB     R3,[R1, #+460]
        ORR      R2,R2,R3, LSL #+16
        LDRB     R1,[R1, #+461]
        ORR      R1,R2,R1, LSL #+24
        STR      R1,[R8, #+0]
//   79 
//   80 	return result;
??DFS_GetPtnStart_1:
        POP      {R4-R8,PC}       ;; return
        CFI EndBlock cfiBlock2
//   81 }
//   82 
//   83 
//   84 /*
//   85 	Retrieve volume info from BPB and store it in a VOLINFO structure
//   86 	You must provide the unit and starting sector of the filesystem, and
//   87 	a pointer to a sector buffer for scratch
//   88 	Attempts to read BPB and glean information about the FS from that.
//   89 	Returns 0 OK, nonzero for any error.
//   90 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock3 Using cfiCommon0
        CFI Function DFS_GetVolInfo
        THUMB
//   91 uint32_t DFS_GetVolInfo(uint8_t unit, uint8_t *scratchsector, uint32_t startsector, PVOLINFO volinfo)
//   92 {
DFS_GetVolInfo:
        PUSH     {R4-R6,LR}
        CFI R14 Frame(CFA, -4)
        CFI R6 Frame(CFA, -8)
        CFI R5 Frame(CFA, -12)
        CFI R4 Frame(CFA, -16)
        CFI CFA R13+16
        MOVS     R4,R1
        MOVS     R5,R2
        MOVS     R6,R3
//   93   //uint32_t SectorSize;  
//   94   
//   95   PLBR lbr = (PLBR) scratchsector;
//   96 	volinfo->unit = unit;
        STRB     R0,[R6, #+0]
//   97 	volinfo->startsector = startsector;
        STR      R5,[R6, #+16]
//   98 
//   99 	if(DFS_ReadSector(0,scratchsector, startsector, 512)) return DFS_ERRMISC;
        MOV      R2,#+512
        LSLS     R1,R5,#+9
        MOVS     R0,R4
        BL       __Disk_Buff_RD
//  100 	volinfo->sectorsize =(uint16_t)lbr->bpb.bytepersec_l|(((uint16_t)lbr->bpb.bytepersec_h)<<8);
        LDRB     R0,[R4, #+11]
        LDRB     R1,[R4, #+12]
        ORR      R0,R0,R1, LSL #+8
        STRH     R0,[R6, #+52]
//  101 
//  102 	volinfo->secperclus = lbr->bpb.secperclus;									//SecPerClus=volinfo->secperclus
        LDRB     R0,[R4, #+13]
        STRB     R0,[R6, #+20]
//  103 	volinfo->reservedsecs = (uint16_t) lbr->bpb.reserved_l |
//  104 		  (((uint16_t) lbr->bpb.reserved_h) << 8);
        LDRB     R0,[R4, #+14]
        LDRB     R1,[R4, #+15]
        ORR      R0,R0,R1, LSL #+8
        STRH     R0,[R6, #+22]
//  105 
//  106 	volinfo->numsecs =  (uint16_t) lbr->bpb.sectors_s_l |
//  107 		  (((uint16_t) lbr->bpb.sectors_s_h) << 8);	
        LDRB     R0,[R4, #+19]
        LDRB     R1,[R4, #+20]
        ORR      R0,R0,R1, LSL #+8
        STR      R0,[R6, #+24]
//  108 
//  109 	if (!volinfo->numsecs)
        CBNZ     R0,??DFS_GetVolInfo_0
//  110 		volinfo->numsecs = (uint32_t) lbr->bpb.sectors_l_0 |
//  111 		  (((uint32_t) lbr->bpb.sectors_l_1) << 8) |
//  112 		  (((uint32_t) lbr->bpb.sectors_l_2) << 16) |
//  113 		  (((uint32_t) lbr->bpb.sectors_l_3) << 24);
        LDRB     R0,[R4, #+32]
        LDRB     R1,[R4, #+33]
        ORR      R0,R0,R1, LSL #+8
        LDRB     R1,[R4, #+34]
        ORR      R0,R0,R1, LSL #+16
        LDRB     R1,[R4, #+35]
        ORR      R0,R0,R1, LSL #+24
        STR      R0,[R6, #+24]
//  114 
//  115 	// If secperfat is 0, we must be in a FAT32 volume; get secperfat
//  116 	// from the FAT32 EBPB. The volume label and system ID string are also
//  117 	// in different locations for FAT12/16 vs FAT32.
//  118 	//FAT_SIZE
//  119 	volinfo->secperfat =  (uint16_t) lbr->bpb.secperfat_l |
//  120 		  (((uint16_t) lbr->bpb.secperfat_h) << 8);		
??DFS_GetVolInfo_0:
        LDRB     R0,[R4, #+22]
        LDRB     R1,[R4, #+23]
        ORR      R0,R0,R1, LSL #+8
        STR      R0,[R6, #+28]
//  121 
//  122 	if (!volinfo->secperfat) 
        CBNZ     R0,??DFS_GetVolInfo_1
//  123 	{
//  124 		volinfo->secperfat = (uint32_t) lbr->ebpb.ebpb32.fatsize_0 |
//  125 		  (((uint32_t) lbr->ebpb.ebpb32.fatsize_1) << 8) |
//  126 		  (((uint32_t) lbr->ebpb.ebpb32.fatsize_2) << 16) |
//  127 		  (((uint32_t) lbr->ebpb.ebpb32.fatsize_3) << 24);
        LDRB     R0,[R4, #+36]
        LDRB     R1,[R4, #+37]
        ORR      R0,R0,R1, LSL #+8
        LDRB     R1,[R4, #+38]
        ORR      R0,R0,R1, LSL #+16
        LDRB     R1,[R4, #+39]
        ORR      R0,R0,R1, LSL #+24
        STR      R0,[R6, #+28]
//  128 
//  129 		memcpy(volinfo->label, lbr->ebpb.ebpb32.label, 11);
        MOVS     R2,#+11
        ADD      R1,R4,#+71
        B.N      ??DFS_GetVolInfo_2
//  130 		volinfo->label[11] = 0;
//  131 	
//  132 // tag: OEMID, refer dosfs.h
//  133 //		memcpy(volinfo->system, lbr->ebpb.ebpb32.system, 8);
//  134 //		volinfo->system[8] = 0; 
//  135 	}
//  136 	else 
//  137 	{
//  138 		memcpy(volinfo->label, lbr->ebpb.ebpb.label, 11);
??DFS_GetVolInfo_1:
        MOVS     R2,#+11
        ADD      R1,R4,#+43
??DFS_GetVolInfo_2:
        ADDS     R0,R6,#+2
        BL       __aeabi_memcpy
//  139 		volinfo->label[11] = 0;
        MOVS     R0,#+0
        STRB     R0,[R6, #+13]
//  140 	
//  141 // tag: OEMID, refer dosfs.h
//  142 //		memcpy(volinfo->system, lbr->ebpb.ebpb.system, 8);
//  143 //		volinfo->system[8] = 0; 
//  144 	}
//  145 
//  146 	// note: if rootentries is 0, we must be in a FAT32 volume.
//  147 	volinfo->rootentries =  (uint16_t) lbr->bpb.rootentries_l |
//  148 		  (((uint16_t) lbr->bpb.rootentries_h) << 8);
        LDRB     R0,[R4, #+17]
        LDRB     R1,[R4, #+18]
        ORR      R0,R0,R1, LSL #+8
        STRH     R0,[R6, #+32]
//  149 
//  150 	// after extracting raw info we perform some useful precalculations
//  151 	volinfo->fat1 = (startsector + volinfo->reservedsecs)*(volinfo->sectorsize/SECTOR_SIZE);		//???
        LDRH     R1,[R6, #+52]
        LSRS     R1,R1,#+9
        LDRH     R2,[R6, #+22]
        ADDS     R2,R2,R5
        MULS     R2,R2,R1
        STR      R2,[R6, #+40]
//  152 
//  153 	// The calculation below is designed to round up the root directory size for FAT12/16
//  154 	// and to simply ignore the root directory for FAT32, since it's a normal, expandable
//  155 	// file in that situation.
//  156 	if (volinfo->rootentries) 
        LDR      R3,[R6, #+28]
        MULS     R1,R3,R1
        ADD      R1,R2,R1, LSL #+1
        CBZ      R0,??DFS_GetVolInfo_3
//  157 	{
//  158 		volinfo->rootdir = volinfo->fat1 + (volinfo->secperfat * 2)*(volinfo->sectorsize/SECTOR_SIZE);//+ (SectorSize - 1))
//  159 		volinfo->dataarea = volinfo->rootdir+ ((volinfo->rootentries * 32)/SECTOR_SIZE);//
        LSLS     R0,R0,#+5
        ASRS     R2,R0,#+8
        ADD      R0,R0,R2, LSR #+23
        ADD      R0,R1,R0, ASR #+9
        STR      R0,[R6, #+48]
        B.N      ??DFS_GetVolInfo_4
//  160 	}
//  161 	else 
//  162 	{
//  163 		volinfo->dataarea = volinfo->fat1 + (volinfo->secperfat * 2*(volinfo->sectorsize/SECTOR_SIZE));//SectorSize
??DFS_GetVolInfo_3:
        STR      R1,[R6, #+48]
//  164 		volinfo->rootdir = (uint32_t) lbr->ebpb.ebpb32.root_0 |
//  165 		  (((uint32_t) lbr->ebpb.ebpb32.root_1) << 8) |
//  166 		  (((uint32_t) lbr->ebpb.ebpb32.root_2) << 16) |
//  167 		  (((uint32_t) lbr->ebpb.ebpb32.root_3) << 24);
        LDRB     R0,[R4, #+44]
        LDRB     R1,[R4, #+45]
        ORR      R0,R0,R1, LSL #+8
        LDRB     R1,[R4, #+46]
        ORR      R0,R0,R1, LSL #+16
        LDRB     R1,[R4, #+47]
        ORR      R1,R0,R1, LSL #+24
??DFS_GetVolInfo_4:
        STR      R1,[R6, #+44]
//  168 	}
//  169 //DirSecNum = (volinfo->rootentries * 32)/volinfo->sectorsize ;
//  170 //Root_Addr=volinfo->fat1 + (volinfo->secperfat * 2)*SectorSize;
//  171 // Calculate number of clusters in data area and infer FAT type from this information.
//  172 	volinfo->numclusters = (volinfo->numsecs - volinfo->dataarea) / volinfo->secperclus;
        LDR      R0,[R6, #+24]
        LDR      R1,[R6, #+48]
        SUBS     R0,R0,R1
        LDRB     R1,[R6, #+20]
        UDIV     R0,R0,R1
        STR      R0,[R6, #+36]
//  173 	if (volinfo->numclusters < 4085)
        MOVW     R1,#+4085
        CMP      R0,R1
        BCS.N    ??DFS_GetVolInfo_5
//  174 		volinfo->filesystem = FAT12;
        MOVS     R0,#+0
        B.N      ??DFS_GetVolInfo_6
//  175 	else if (volinfo->numclusters < 65525)
??DFS_GetVolInfo_5:
        MOVW     R1,#+65525
        CMP      R0,R1
        BCS.N    ??DFS_GetVolInfo_7
//  176 		volinfo->filesystem = FAT16;
        MOVS     R0,#+1
        B.N      ??DFS_GetVolInfo_6
//  177 	else
//  178 		volinfo->filesystem = FAT32;
??DFS_GetVolInfo_7:
        MOVS     R0,#+2
??DFS_GetVolInfo_6:
        STRB     R0,[R6, #+1]
//  179 
//  180 	return DFS_OK;
        MOVS     R0,#+0
        POP      {R4-R6,PC}       ;; return
        CFI EndBlock cfiBlock3
//  181 }
//  182 
//  183 /*
//  184 	Fetch FAT entry for specified cluster number
//  185 	You must provide a scratch buffer for one sector (SECTOR_SIZE) and a populated VOLINFO
//  186 	Returns a FAT32 BAD_CLUSTER value for any error, otherwise the contents of the desired
//  187 	FAT entry.
//  188 	scratchcache should point to a UINT32. This variable caches the physical sector number
//  189 	last read into the scratch buffer for performance enhancement reasons.
//  190 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock4 Using cfiCommon0
        CFI Function DFS_GetFAT
        THUMB
//  191 uint32_t DFS_GetFAT(PVOLINFO volinfo,uint8_t *scratch,uint32_t *scratchcache, uint32_t cluster)//
//  192 {
DFS_GetFAT:
        PUSH     {R4-R9,LR}
        CFI R14 Frame(CFA, -4)
        CFI R9 Frame(CFA, -8)
        CFI R8 Frame(CFA, -12)
        CFI R7 Frame(CFA, -16)
        CFI R6 Frame(CFA, -20)
        CFI R5 Frame(CFA, -24)
        CFI R4 Frame(CFA, -28)
        CFI CFA R13+28
        SUB      SP,SP,#+12
        CFI CFA R13+40
        MOV      R9,R0
        MOVS     R5,R1
        MOVS     R6,R2
        MOVS     R4,R3
//  193 	uint32_t offset, sector, result;
//  194 
//  195 	
//  196 	if (volinfo->filesystem == FAT12) {
        LDRB     R0,[R9, #+1]
        CMP      R0,#+0
        BNE.N    ??DFS_GetFAT_0
//  197 		offset = cluster + (cluster / 2);
        ADD      R7,R4,R4, LSR #+1
//  198 	}
//  199 	else if (volinfo->filesystem == FAT16) {
//  200 		offset = cluster * 2;
//  201 	}
//  202 	else if (volinfo->filesystem == FAT32) {
//  203 		offset = cluster * 4;
//  204 	}
//  205 	else
//  206 		return 0x0ffffff7;	// FAT32 bad cluster	
//  207 
//  208 	// at this point, offset is the BYTE offset of the desired sector from the start
//  209 	// of the FAT. Calculate the physical sector containing this FAT entry.
//  210 	sector = ldiv(offset, SECTOR_SIZE).quot + volinfo->fat1;
??DFS_GetFAT_1:
        MOV      R2,#+512
        MOVS     R1,R7
        ADD      R0,SP,#+0
        BL       ldiv
        LDR      R0,[SP, #+0]
        LDR      R1,[R9, #+40]
        ADD      R8,R1,R0
//  211 
//  212 	// If this is not the same sector we last read, then read it into RAM  
//  213 	if (sector != *scratchcache) {
        LDR      R0,[R6, #+0]
        CMP      R8,R0
        BEQ.N    ??DFS_GetFAT_2
//  214 		if(DFS_ReadSector(volinfo->unit, scratch, sector, 1)) {
        MOV      R2,#+512
        LSL      R1,R8,#+9
        MOVS     R0,R5
        BL       __Disk_Buff_RD
//  215 			// avoid anyone assuming that this cache value is still valid, which
//  216 			// might cause disk corruption
//  217 			*scratchcache = 0;
//  218 			return 0x0ffffff7;	// FAT32 bad cluster	
//  219 		}
//  220 		*scratchcache = sector;
        STR      R8,[R6, #+0]
//  221 	}
//  222 
//  223 	// At this point, we "merely" need to extract the relevant entry.
//  224 	// This is easy for FAT16 and FAT32, but a royal PITA for FAT12 as a single entry
//  225 	// may span a sector boundary. The normal way around this is always to read two
//  226 	// FAT sectors, but that luxury is (by design intent) unavailable to DOSFS.
//  227 	offset = ldiv(offset, SECTOR_SIZE).rem;
??DFS_GetFAT_2:
        MOV      R2,#+512
        MOVS     R1,R7
        ADD      R0,SP,#+0
        BL       ldiv
        LDR      R0,[SP, #+4]
//  228 
//  229 	if (volinfo->filesystem == FAT12) {
        LDRB     R1,[R9, #+1]
        CMP      R1,#+0
        BNE.N    ??DFS_GetFAT_3
//  230 		// Special case for sector boundary - Store last byte of current sector.
//  231 		// Then read in the next sector and put the first byte of that sector into
//  232 		// the high byte of result.
//  233 		if (offset == SECTOR_SIZE - 1) {
        MOVW     R1,#+511
        CMP      R0,R1
        BNE.N    ??DFS_GetFAT_4
//  234 			result = (uint32_t) scratch[offset];
        LDRB     R7,[R5, #+511]
//  235 			sector++;
        ADD      R8,R8,#+1
//  236 			if(DFS_ReadSector(volinfo->unit, scratch, sector, 1)) {
        MOV      R2,#+512
        LSL      R1,R8,#+9
        MOVS     R0,R5
        BL       __Disk_Buff_RD
//  237 				// avoid anyone assuming that this cache value is still valid, which
//  238 				// might cause disk corruption
//  239 				*scratchcache = 0;
//  240 				return 0x0ffffff7;	// FAT32 bad cluster	
//  241 			}
//  242 			*scratchcache = sector;
        STR      R8,[R6, #+0]
//  243 			// Thanks to Claudio Leonel for pointing out this missing line.
//  244 			if(cluster & 1)
        TST      R4,#0x1
        BEQ.N    ??DFS_GetFAT_5
//  245 			{
//  246 				result = ((result & 0xf0)>>4) | (((uint32_t)scratch[0]) << 8);
        AND      R0,R7,#0xF0
        LDRB     R1,[R5, #+0]
        LSLS     R1,R1,#+8
        ORR      R0,R1,R0, LSR #+4
        B.N      ??DFS_GetFAT_6
//  247 			}
??DFS_GetFAT_0:
        CMP      R0,#+1
        BNE.N    ??DFS_GetFAT_7
        LSLS     R7,R4,#+1
        B.N      ??DFS_GetFAT_1
??DFS_GetFAT_7:
        CMP      R0,#+2
        BNE.N    ??DFS_GetFAT_8
        LSLS     R7,R4,#+2
        B.N      ??DFS_GetFAT_1
??DFS_GetFAT_8:
        LDR.W    R0,??DataTable6  ;; 0xffffff7
        B.N      ??DFS_GetFAT_6
//  248 			else
//  249 			{
//  250 				result = result |(((uint32_t)scratch[0] & 0xf)<<8);
??DFS_GetFAT_5:
        LDRB     R0,[R5, #+0]
        AND      R0,R0,#0xF
        ORR      R0,R7,R0, LSL #+8
        B.N      ??DFS_GetFAT_6
//  251 			}
//  252 		}
//  253 		else {
//  254 			if (cluster & 1)
??DFS_GetFAT_4:
        ADDS     R1,R0,R5
        TST      R4,#0x1
        LDRB     R0,[R0, R5]
        LDRB     R1,[R1, #+1]
        BEQ.N    ??DFS_GetFAT_9
//  255 				result = (((uint32_t) scratch[offset] & 0xf0)>>4) |((uint32_t)scratch[offset+1] <<8);
        LSLS     R1,R1,#+8
        ORR      R0,R1,R0, LSR #+4
        B.N      ??DFS_GetFAT_6
//  256 			else
//  257 				result = (uint32_t)scratch[offset] | (((uint32_t)scratch[offset+1] & 0x0f) << 8);
??DFS_GetFAT_9:
        AND      R1,R1,#0xF
        ORR      R0,R0,R1, LSL #+8
        B.N      ??DFS_GetFAT_6
//  258 		}
//  259 		
//  260 	}
//  261 	else if (volinfo->filesystem == FAT16) {
??DFS_GetFAT_3:
        CMP      R1,#+1
        BNE.N    ??DFS_GetFAT_10
//  262 		result = (uint32_t) scratch[offset] |
//  263 		  ((uint32_t) scratch[offset+1]) << 8;
        LDRB     R1,[R0, R5]
        ADDS     R0,R0,R5
        LDRB     R0,[R0, #+1]
        ORR      R0,R1,R0, LSL #+8
        B.N      ??DFS_GetFAT_6
//  264 	}
//  265 	else if (volinfo->filesystem == FAT32) {
??DFS_GetFAT_10:
        CMP      R1,#+2
        BNE.N    ??DFS_GetFAT_11
//  266 		result = ((uint32_t) scratch[offset] |
//  267 		  ((uint32_t) scratch[offset+1]) << 8 |
//  268 		  ((uint32_t) scratch[offset+2]) << 16 |
//  269 		  ((uint32_t) scratch[offset+3]) << 24) & 0x0fffffff;
        ADDS     R1,R0,R5
        LDRB     R0,[R0, R5]
        LDRB     R2,[R1, #+1]
        ORR      R0,R0,R2, LSL #+8
        LDRB     R2,[R1, #+2]
        ORR      R0,R0,R2, LSL #+16
        LDRB     R1,[R1, #+3]
        ORR      R0,R0,R1, LSL #+24
        LSLS     R0,R0,#+4
        LSRS     R0,R0,#+4
        B.N      ??DFS_GetFAT_6
//  270 	}
//  271 	else
//  272 		result = 0x0ffffff7;	// FAT32 bad cluster	
??DFS_GetFAT_11:
        LDR.W    R0,??DataTable6  ;; 0xffffff7
//  273 	return result;
??DFS_GetFAT_6:
        ADD      SP,SP,#+12
        CFI CFA R13+28
        POP      {R4-R9,PC}       ;; return
        CFI EndBlock cfiBlock4
//  274 }
//  275 
//  276 
//  277 /*
//  278 	Set FAT entry for specified cluster number
//  279 	You must provide a scratch buffer for one sector (SECTOR_SIZE) and a populated VOLINFO
//  280 	Returns DFS_ERRMISC for any error, otherwise DFS_OK
//  281 	scratchcache should point to a UINT32. This variable caches the physical sector number
//  282 	last read into the scratch buffer for performance enhancement reasons.
//  283 
//  284 	NOTE: This code is HIGHLY WRITE-INEFFICIENT, particularly for flash media. Considerable
//  285 	performance gains can be realized by caching the sector. However this is difficult to
//  286 	achieve on FAT12 without requiring 2 sector buffers of scratch space, and it is a design
//  287 	requirement of this code to operate on a single 512-byte scratch.
//  288 
//  289 	If you are operating DOSFS over flash, you are strongly advised to implement a writeback
//  290 	cache in your physical I/O driver. This will speed up your code significantly and will
//  291 	also conserve power and flash write life.
//  292 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock5 Using cfiCommon0
        CFI Function DFS_SetFAT
        THUMB
//  293 uint32_t DFS_SetFAT(PVOLINFO volinfo, uint8_t *scratch, uint32_t *scratchcache, uint32_t cluster, uint32_t new_contents)
//  294 {
DFS_SetFAT:
        PUSH     {R4-R11,LR}
        CFI R14 Frame(CFA, -4)
        CFI R11 Frame(CFA, -8)
        CFI R10 Frame(CFA, -12)
        CFI R9 Frame(CFA, -16)
        CFI R8 Frame(CFA, -20)
        CFI R7 Frame(CFA, -24)
        CFI R6 Frame(CFA, -28)
        CFI R5 Frame(CFA, -32)
        CFI R4 Frame(CFA, -36)
        CFI CFA R13+36
        SUB      SP,SP,#+12
        CFI CFA R13+48
        MOVS     R5,R0
        MOVS     R6,R1
        MOVS     R7,R2
        MOVS     R4,R3
        LDR      R8,[SP, #+48]
//  295 	uint32_t offset, result,sector=0;
//  296 
//  297 
//  298 	if (volinfo->filesystem == FAT12) {
        LDRB     R0,[R5, #+1]
        CMP      R0,#+0
        BNE.N    ??DFS_SetFAT_0
//  299 		offset = cluster + (cluster / 2);
        ADD      R9,R4,R4, LSR #+1
//  300 		new_contents &=0xfff;
        LSLS     R8,R8,#+20
        LSRS     R8,R8,#+20
//  301 	}
//  302 	else if (volinfo->filesystem == FAT16) {
//  303 		offset = cluster * 2;
//  304 		new_contents &=0xffff;
//  305 	}
//  306 	else if (volinfo->filesystem == FAT32) {
//  307 		offset = cluster * 4;
//  308 		new_contents &=0x0fffffff;	// FAT32 is really "FAT28"
//  309 	}
//  310 	else
//  311 		return DFS_ERRMISC;	
//  312 
//  313 	// at this point, offset is the BYTE offset of the desired sector from the start
//  314 	// of the FAT. Calculate the physical sector containing this FAT entry.
//  315 	sector = ldiv(offset, SECTOR_SIZE).quot + volinfo->fat1;
??DFS_SetFAT_1:
        MOV      R2,#+512
        MOV      R1,R9
        ADD      R0,SP,#+0
        BL       ldiv
        LDR      R0,[SP, #+0]
        LDR      R1,[R5, #+40]
        ADD      R10,R1,R0
//  316 	
//  317 	// If this is not the same sector we last read, then read it into RAM
//  318 	if (sector != *scratchcache) {
        LDR      R0,[R7, #+0]
        CMP      R10,R0
        BEQ.N    ??DFS_SetFAT_2
//  319 		if(DFS_ReadSector(volinfo->unit, scratch, sector, 1)) {
        MOV      R2,#+512
        LSL      R1,R10,#+9
        MOVS     R0,R6
        BL       __Disk_Buff_RD
//  320 			// avoid anyone assuming that this cache value is still valid, which
//  321 			// might cause disk corruption
//  322 			*scratchcache = 0;
//  323 			return DFS_ERRMISC;
//  324 		}
//  325 		*scratchcache = sector;
        STR      R10,[R7, #+0]
//  326 	}
//  327 
//  328 	// At this point, we "merely" need to extract the relevant entry.
//  329 	// This is easy for FAT16 and FAT32, but a royal PITA for FAT12 as a single entry
//  330 	// may span a sector boundary. The normal way around this is always to read two
//  331 	// FAT sectors, but that luxury is (by design intent) unavailable to DOSFS.
//  332 	offset = ldiv(offset, SECTOR_SIZE).rem;
??DFS_SetFAT_2:
        MOV      R2,#+512
        MOV      R1,R9
        ADD      R0,SP,#+0
        BL       ldiv
        LDR      R0,[SP, #+4]
//  333 
//  334 	if (volinfo->filesystem == FAT12) {
        LDRB     R1,[R5, #+1]
        CMP      R1,#+0
        BNE.W    ??DFS_SetFAT_3
//  335 
//  336 		// If this is an odd cluster, pre-shift the desired new contents 4 bits to
//  337 		// make the calculations below simpler
//  338 		if (cluster & 1)
        TST      R4,#0x1
        IT       NE 
//  339 			new_contents = new_contents << 4;
        LSLNE    R8,R8,#+4
//  340 
//  341 		// Special case for sector boundary
//  342 		if (offset == SECTOR_SIZE - 1) {
        MOVW     R1,#+511
        CMP      R0,R1
        BNE.N    ??DFS_SetFAT_4
//  343 
//  344 			// Odd cluster: High 12 bits being set
//  345 			if (cluster & 1) {
        TST      R4,#0x1
        BEQ.N    ??DFS_SetFAT_5
//  346 				scratch[offset] = (scratch[offset] & 0x0f) | new_contents & 0xf0;
        LDRB     R0,[R6, #+511]
        AND      R0,R0,#0xF
        AND      R1,R8,#0xF0
        ORRS     R0,R1,R0
        STRB     R0,[R6, #+511]
        B.N      ??DFS_SetFAT_6
//  347 			}
??DFS_SetFAT_0:
        CMP      R0,#+1
        BNE.N    ??DFS_SetFAT_7
        LSL      R9,R4,#+1
        UXTH     R8,R8
        B.N      ??DFS_SetFAT_1
??DFS_SetFAT_7:
        CMP      R0,#+2
        BNE.N    ??DFS_SetFAT_8
        LSL      R9,R4,#+2
        LSLS     R8,R8,#+4
        LSRS     R8,R8,#+4
        B.N      ??DFS_SetFAT_1
??DFS_SetFAT_8:
        MOV      R0,#-1
        B.N      ??DFS_SetFAT_9
//  348 			// Even cluster: Low 12 bits being set
//  349 			else {
//  350 				scratch[offset] = new_contents & 0xff;
??DFS_SetFAT_5:
        STRB     R8,[R6, #+511]
//  351 			}
//  352 			result = DFS_WriteSector(volinfo->unit, scratch, *scratchcache, 1);//
??DFS_SetFAT_6:
        LDR      R0,[R7, #+0]
        LSL      R9,R0,#+9
        MOV      R1,R9
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R9,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
        MOV      R9,#+0
//  353 			// mirror the FAT into copy 2
//  354 			if (DFS_OK == result)
//  355 				result = DFS_WriteSector(volinfo->unit, scratch, (*scratchcache)+volinfo->secperfat, 1);
        LDR      R0,[R7, #+0]
        LDR      R1,[R5, #+28]
        ADDS     R0,R1,R0
        LSL      R11,R0,#+9
        MOV      R1,R11
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R11,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
//  356 
//  357 			// If we wrote that sector OK, then read in the subsequent sector
//  358 			// and poke the first byte with the remainder of this FAT entry.
//  359 			if (DFS_OK == result) 
//  360 			{
//  361 				sector++;
//  362 				*scratchcache=sector;
        ADD      R0,R10,#+1
        STR      R0,[R7, #+0]
//  363 				result = DFS_ReadSector(volinfo->unit, scratch, *scratchcache, 1);
        MOV      R2,#+512
        LSLS     R1,R0,#+9
        MOVS     R0,R6
        BL       __Disk_Buff_RD
//  364 				if (DFS_OK == result) {
//  365 					// Odd cluster: High 12 bits being set
//  366 					if (cluster & 1) {
        TST      R4,#0x1
        BEQ.N    ??DFS_SetFAT_10
//  367 						scratch[0] = (new_contents & 0xff00)>>8;
        LSR      R0,R8,#+8
        B.N      ??DFS_SetFAT_11
//  368 					}
//  369 					// Even cluster: Low 12 bits being set
//  370 					else {
//  371 						scratch[0] = (scratch[0] & 0xf0) | ((new_contents & 0x0f00)>>8);
??DFS_SetFAT_10:
        LDRB     R0,[R6, #+0]
        AND      R0,R0,#0xF0
        AND      R1,R8,#0xF00
        LSRS     R1,R1,#+8
        ORRS     R0,R1,R0
??DFS_SetFAT_11:
        STRB     R0,[R6, #+0]
//  372 					}
//  373 					result = DFS_WriteSector(volinfo->unit, scratch, *scratchcache, 1);
        LDR      R0,[R7, #+0]
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
//  374 					// mirror the FAT into copy 2
//  375 					if (DFS_OK == result)
//  376 						result = DFS_WriteSector(volinfo->unit, scratch, (*scratchcache)+volinfo->secperfat, 1);
        LDR      R0,[R7, #+0]
        LDR      R1,[R5, #+28]
        ADDS     R0,R1,R0
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
??DFS_SetFAT_12:
        BL       __Disk_Buff_WR
        B.N      ??DFS_SetFAT_13
//  377 				}
//  378 				else {
//  379 					// avoid anyone assuming that this cache value is still valid, which
//  380 					// might cause disk corruption
//  381 					*scratchcache = 0;
//  382 				}
//  383 			}
//  384 		} // if (offset == SECTOR_SIZE - 1)
//  385 
//  386 		// Not a sector boundary. But we still have to worry about if it's an odd
//  387 		// or even cluster number.
//  388 		else {
//  389 			// Odd cluster: High 12 bits being set
//  390 			if (cluster & 1) {
??DFS_SetFAT_4:
        ADDS     R1,R0,R6
        TST      R4,#0x1
        BEQ.N    ??DFS_SetFAT_14
//  391 				scratch[offset] = (scratch[offset] & 0x0f) | new_contents & 0xf0;
        LDRB     R2,[R0, R6]
        AND      R2,R2,#0xF
        AND      R3,R8,#0xF0
        ORRS     R2,R3,R2
        STRB     R2,[R0, R6]
//  392 				scratch[offset+1] = (new_contents & 0xff00)>>8;
        LSR      R0,R8,#+8
        B.N      ??DFS_SetFAT_15
//  393 			}
//  394 			// Even cluster: Low 12 bits being set
//  395 			else 
//  396 			{
//  397 					scratch[offset] = new_contents & 0xff;
??DFS_SetFAT_14:
        STRB     R8,[R0, R6]
//  398 					scratch[offset+1] = (scratch[offset+1] & 0xf0) | ((new_contents & 0x0f00)>>8);
        LDRB     R0,[R1, #+1]
        AND      R0,R0,#0xF0
        AND      R2,R8,#0xF00
        LSRS     R2,R2,#+8
        ORRS     R0,R2,R0
??DFS_SetFAT_15:
        STRB     R0,[R1, #+1]
//  399 			}
//  400 			result = DFS_WriteSector(volinfo->unit, scratch, *scratchcache, 1);
        LDR      R0,[R7, #+0]
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
        MOV      R9,#+0
//  401 			// mirror the FAT into copy 2
//  402 			if (DFS_OK == result)
//  403 				result = DFS_WriteSector(volinfo->unit, scratch, (*scratchcache)+volinfo->secperfat, 1);
        LDR      R0,[R7, #+0]
        LDR      R1,[R5, #+28]
        ADDS     R0,R1,R0
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
        B.N      ??DFS_SetFAT_12
//  404 		}
//  405 	}
//  406 	else if (volinfo->filesystem == FAT16) {
??DFS_SetFAT_3:
        CMP      R1,#+1
        BNE.N    ??DFS_SetFAT_16
//  407 		
//  408 		scratch[offset] = (new_contents & 0xff);
        STRB     R8,[R0, R6]
//  409 		scratch[offset+1] = (new_contents & 0xff00) >> 8;
        ADDS     R0,R0,R6
        LSR      R1,R8,#+8
        STRB     R1,[R0, #+1]
//  410 		result = DFS_WriteSector(volinfo->unit, scratch, *scratchcache, 1);//volinfo->secperfat
        LDR      R0,[R7, #+0]
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
        MOV      R9,#+0
//  411 		// mirror the FAT into copy 2
//  412 		if (DFS_OK == result)
//  413 			result = DFS_WriteSector(volinfo->unit, scratch, (*scratchcache)+volinfo->secperfat, 1);//
        LDR      R0,[R7, #+0]
        LDR      R1,[R5, #+28]
        ADDS     R0,R1,R0
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
        B.N      ??DFS_SetFAT_13
//  414 	}
//  415 	else if (volinfo->filesystem == FAT32) {
??DFS_SetFAT_16:
        CMP      R1,#+2
        BNE.N    ??DFS_SetFAT_17
//  416 		scratch[offset] = (new_contents & 0xff);
        STRB     R8,[R0, R6]
//  417 		scratch[offset+1] = (new_contents & 0xff00) >> 8;
        ADDS     R1,R0,R6
        LSR      R0,R8,#+8
        STRB     R0,[R1, #+1]
//  418 		scratch[offset+2] = (new_contents & 0xff0000) >> 16;
        LSR      R0,R8,#+16
        STRB     R0,[R1, #+2]
//  419 		scratch[offset+3] = (scratch[offset+3] & 0xf0) | ((new_contents & 0x0f000000) >> 24);
        LDRB     R0,[R1, #+3]
        AND      R0,R0,#0xF0
        AND      R2,R8,#0xF000000
        LSRS     R2,R2,#+24
        ORRS     R0,R2,R0
        STRB     R0,[R1, #+3]
//  420 		// Note well from the above: Per Microsoft's guidelines we preserve the upper
//  421 		// 4 bits of the FAT32 cluster value. It's unclear what these bits will be used
//  422 		// for; in every example I've encountered they are always zero.
//  423 		result = DFS_WriteSector(volinfo->unit, scratch, *scratchcache, 1);
        LDR      R0,[R7, #+0]
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
        MOV      R9,#+0
//  424 		// mirror the FAT into copy 2
//  425 		if (DFS_OK == result)
//  426 			result = DFS_WriteSector(volinfo->unit, scratch, (*scratchcache)+volinfo->secperfat, 1);
        LDR      R0,[R7, #+0]
        LDR      R1,[R5, #+28]
        ADDS     R0,R1,R0
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R6,#+256
        B.N      ??DFS_SetFAT_12
//  427 	}
//  428 	else
//  429 		result = DFS_ERRMISC;
??DFS_SetFAT_17:
        MOV      R9,#-1
//  430 
//  431 	return result;
??DFS_SetFAT_13:
        MOV      R0,R9
??DFS_SetFAT_9:
        ADD      SP,SP,#+12
        CFI CFA R13+36
        POP      {R4-R11,PC}      ;; return
        CFI EndBlock cfiBlock5
//  432 }
//  433 
//  434 /*
//  435 	Convert a filename element from canonical (8.3) to directory entry (11) form
//  436 	src must point to the first non-separator character.
//  437 	dest must point to a 12-byte buffer.
//  438 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock6 Using cfiCommon0
        CFI Function DFS_CanonicalToDir
        THUMB
//  439 uint8_t *DFS_CanonicalToDir(uint8_t *dest, uint8_t *src)
//  440 {
DFS_CanonicalToDir:
        PUSH     {R4-R6,LR}
        CFI R14 Frame(CFA, -4)
        CFI R6 Frame(CFA, -8)
        CFI R5 Frame(CFA, -12)
        CFI R4 Frame(CFA, -16)
        CFI CFA R13+16
        MOVS     R4,R0
        MOVS     R5,R1
//  441 	uint8_t *destptr = dest;
        MOVS     R6,R4
//  442 
//  443 	memset(dest, ' ', 11);
        MOVS     R2,#+32
        MOVS     R1,#+11
        BL       __aeabi_memset
//  444 	dest[11] = 0;
        MOVS     R0,#+0
        STRB     R0,[R4, #+11]
        MOVS     R0,R4
        B.N      ??DFS_CanonicalToDir_0
//  445 
//  446 	while (*src && (*src != DIR_SEPARATOR) && (destptr - dest < 11)) {
//  447 		if (*src >= 'a' && *src <='z') {
??DFS_CanonicalToDir_1:
        CMP      R1,#+123
        BCS.N    ??DFS_CanonicalToDir_2
//  448 			*destptr++ = (*src - 'a') + 'A';
        LDRB     R1,[R5], #+1
        SUBS     R1,R1,#+32
        STRB     R1,[R6], #+1
//  449 			src++;
//  450 		}
??DFS_CanonicalToDir_0:
        LDRB     R1,[R5, #+0]
        CBZ      R1,??DFS_CanonicalToDir_3
        CMP      R1,#+47
        BEQ.N    ??DFS_CanonicalToDir_3
        SUBS     R2,R6,R0
        CMP      R2,#+11
        BGE.N    ??DFS_CanonicalToDir_3
        CMP      R1,#+97
        BCS.N    ??DFS_CanonicalToDir_1
//  451 		else if (*src == '.') {
        CMP      R1,#+46
        BNE.N    ??DFS_CanonicalToDir_2
//  452 			src++;
        ADDS     R5,R5,#+1
//  453 			destptr = dest + 8;
        ADD      R6,R4,#+8
        B.N      ??DFS_CanonicalToDir_0
//  454 		}
//  455 		else {
//  456 			*destptr++ = *src++;
??DFS_CanonicalToDir_2:
        LDRB     R1,[R5], #+1
        STRB     R1,[R6], #+1
        B.N      ??DFS_CanonicalToDir_0
//  457 		}
//  458 	}
//  459 
//  460 	return dest;
??DFS_CanonicalToDir_3:
        POP      {R4-R6,PC}       ;; return
        CFI EndBlock cfiBlock6
//  461 }
//  462 
//  463 /*
//  464 	Find the first unused FAT entry
//  465 	You must provide a scratch buffer for one sector (SECTOR_SIZE) and a populated VOLINFO
//  466 	Returns a FAT32 BAD_CLUSTER value for any error, otherwise the contents of the desired
//  467 	FAT entry.
//  468 	Returns FAT32 bad_sector (0x0ffffff7) if there is no free cluster available
//  469 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock7 Using cfiCommon0
        CFI Function DFS_GetFreeFAT
        THUMB
//  470 uint32_t DFS_GetFreeFAT(PVOLINFO volinfo, uint8_t *scratch)
//  471 {
DFS_GetFreeFAT:
        PUSH     {R4-R6,LR}
        CFI R14 Frame(CFA, -4)
        CFI R6 Frame(CFA, -8)
        CFI R5 Frame(CFA, -12)
        CFI R4 Frame(CFA, -16)
        CFI CFA R13+16
        SUB      SP,SP,#+8
        CFI CFA R13+24
        MOVS     R6,R0
        MOVS     R4,R1
//  472 	uint32_t i, result = 0xffffffff, scratchcache = 0;
        MOVS     R0,#+0
        STR      R0,[SP, #+0]
//  473 	
//  474 	// Search starts at cluster 2, which is the first usable cluster
//  475 	// NOTE: This search can't terminate at a bad cluster, because there might
//  476 	// legitimately be bad clusters on the disk.
//  477 	for (i=2; i < volinfo->numclusters; i++) {
        MOVS     R5,#+2
        B.N      ??DFS_GetFreeFAT_0
??DFS_GetFreeFAT_1:
        ADDS     R5,R5,#+1
??DFS_GetFreeFAT_0:
        LDR      R0,[R6, #+36]
        CMP      R5,R0
        BCS.N    ??DFS_GetFreeFAT_2
//  478 		result = DFS_GetFAT(volinfo, scratch, &scratchcache, i);
//  479 		if (!result) {
        MOVS     R3,R5
        ADD      R2,SP,#+0
        MOVS     R1,R4
        MOVS     R0,R6
        BL       DFS_GetFAT
        CMP      R0,#+0
        BNE.N    ??DFS_GetFreeFAT_1
//  480 			return i;
        MOVS     R0,R5
        B.N      ??DFS_GetFreeFAT_3
//  481 		}
//  482 	}
//  483 	return 0x0ffffff7;		// Can't find a free cluster
??DFS_GetFreeFAT_2:
        LDR.W    R0,??DataTable6  ;; 0xffffff7
??DFS_GetFreeFAT_3:
        ADD      SP,SP,#+8
        CFI CFA R13+16
        POP      {R4-R6,PC}       ;; return
        CFI EndBlock cfiBlock7
//  484 }
//  485 
//  486 
//  487 /*
//  488 	Open a directory for enumeration by DFS_GetNextDirEnt
//  489 	You must supply a populated VOLINFO (see DFS_GetVolInfo)
//  490 	The empty string or a string containing only the directory separator are
//  491 	considered to be the root directory.
//  492 	Returns 0 OK, nonzero for any error.
//  493 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock8 Using cfiCommon0
        CFI Function DFS_OpenDir
        THUMB
//  494 uint32_t DFS_OpenDir(PVOLINFO volinfo, uint8_t *dirname, PDIRINFO dirinfo)
//  495 {
DFS_OpenDir:
        PUSH     {R4-R8,LR}
        CFI R14 Frame(CFA, -4)
        CFI R8 Frame(CFA, -8)
        CFI R7 Frame(CFA, -12)
        CFI R6 Frame(CFA, -16)
        CFI R5 Frame(CFA, -20)
        CFI R4 Frame(CFA, -24)
        CFI CFA R13+24
        SUB      SP,SP,#+48
        CFI CFA R13+72
        MOVS     R5,R0
        MOVS     R4,R1
        MOVS     R6,R2
//  496 	//  char Rvalue = 2; 
//  497  
//  498 	if (!strlen((char *) dirname) || (strlen((char *) dirname) == 1 && dirname[0] == DIR_SEPARATOR)) {
        MOVS     R0,R4
        BL       strlen
        CBZ      R0,??DFS_OpenDir_0
        MOVS     R0,R4
        BL       strlen
        CMP      R0,#+1
        BNE.N    ??DFS_OpenDir_1
        LDRB     R0,[R4, #+0]
        CMP      R0,#+47
        BNE.N    ??DFS_OpenDir_1
//  499 		if (volinfo->filesystem == FAT32) {
??DFS_OpenDir_0:
        LDRB     R0,[R5, #+1]
        CMP      R0,#+2
        BNE.N    ??DFS_OpenDir_2
//  500 			dirinfo->currentcluster = volinfo->rootdir;
        LDR      R0,[R5, #+44]
        STR      R0,[R6, #+0]
//  501 			dirinfo->currentsector = 0;
        MOVS     R0,#+0
        STRB     R0,[R6, #+4]
//  502 			dirinfo->currententry = 0;
        STRB     R0,[R6, #+5]
//  503 
//  504 			// read first sector of directory
//  505 			return (DFS_ReadSector(volinfo->unit, dirinfo->scratch, volinfo->dataarea + ((volinfo->rootdir - 2) * volinfo->secperclus*2), 1));
        MOV      R2,#+512
        LDR      R0,[R5, #+48]
        LDR      R1,[R5, #+44]
        SUBS     R1,R1,#+2
        LDRB     R3,[R5, #+20]
        MULS     R1,R1,R3
        ADD      R0,R0,R1, LSL #+1
        LSLS     R1,R0,#+9
        LDR      R0,[R6, #+8]
        BL       __Disk_Buff_RD
        B.N      ??DFS_OpenDir_3
//  506 			
//  507 		}
//  508 		else {
//  509 			dirinfo->currentcluster = 0;
??DFS_OpenDir_2:
        MOVS     R0,#+0
        STR      R0,[R6, #+0]
//  510 			dirinfo->currentsector = 0;
        STRB     R0,[R6, #+4]
//  511 			dirinfo->currententry = 0;
        STRB     R0,[R6, #+5]
//  512 
//  513 			// read first sector of directory
//  514 			return (DFS_ReadSector(volinfo->unit, dirinfo->scratch, volinfo->rootdir, 1));
        MOV      R2,#+512
        LDR      R0,[R5, #+44]
        LSLS     R1,R0,#+9
        LDR      R0,[R6, #+8]
        BL       __Disk_Buff_RD
        B.N      ??DFS_OpenDir_3
//  515 			
//  516 		}
//  517 	}
//  518 
//  519 	// This is not the root directory. We need to find the start of this subdirectory.
//  520 	// We do this by devious means, using our own companion function DFS_GetNext.
//  521 	else {
//  522 		uint8_t tmpfn[12];
//  523 		uint8_t *ptr = dirname;
//  524 		uint32_t result;
//  525 		DIRENT de;
//  526 
//  527 		if (volinfo->filesystem == FAT32) {
??DFS_OpenDir_1:
        LDRB     R0,[R5, #+1]
        CMP      R0,#+2
        BNE.N    ??DFS_OpenDir_4
//  528 			dirinfo->currentcluster = volinfo->rootdir;
        LDR      R0,[R5, #+44]
        STR      R0,[R6, #+0]
//  529 			dirinfo->currentsector = 0;
        MOVS     R0,#+0
        STRB     R0,[R6, #+4]
//  530 			dirinfo->currententry = 0;
        STRB     R0,[R6, #+5]
//  531 
//  532 			// read first sector of directory
//  533 			if (DFS_ReadSector(volinfo->unit, dirinfo->scratch, volinfo->dataarea + ((volinfo->rootdir - 2) * volinfo->secperclus*2), 1))
        MOV      R2,#+512
        LDR      R0,[R5, #+48]
        LDR      R1,[R5, #+44]
        SUBS     R1,R1,#+2
        LDRB     R3,[R5, #+20]
        MULS     R1,R1,R3
        ADD      R0,R0,R1, LSL #+1
        B.N      ??DFS_OpenDir_5
//  534 				return DFS_ERRMISC;
//  535 		}
//  536 		else {
//  537 			dirinfo->currentcluster = 0;
??DFS_OpenDir_4:
        MOVS     R0,#+0
        STR      R0,[R6, #+0]
//  538 			dirinfo->currentsector = 0;
        STRB     R0,[R6, #+4]
//  539 			dirinfo->currententry = 0;
        STRB     R0,[R6, #+5]
//  540 
//  541 			// read first sector of directory
//  542 			if (DFS_ReadSector(volinfo->unit, dirinfo->scratch, volinfo->rootdir, 1))
        MOV      R2,#+512
        LDR      R0,[R5, #+44]
??DFS_OpenDir_5:
        LSLS     R1,R0,#+9
        LDR      R0,[R6, #+8]
        BL       __Disk_Buff_RD
//  543 				return DFS_ERRMISC;
//  544 		}
//  545 
//  546 		// skip leading path separators
//  547 		while (*ptr == DIR_SEPARATOR && *ptr)
        LDRB     R0,[R4, #+0]
        CMP      R0,#+47
        BNE.N    ??DFS_OpenDir_6
//  548 			ptr++;
??DFS_OpenDir_7:
        LDRB     R0,[R4, #+1]!
        CMP      R0,#+47
        BEQ.N    ??DFS_OpenDir_7
//  549 
//  550 		// Scan the path from left to right, finding the start cluster of each entry
//  551 		// Observe that this code is inelegant, but obviates the need for recursion.
//  552 		while (*ptr) {
??DFS_OpenDir_6:
        LDRB     R0,[R4, #+0]
        CMP      R0,#+0
        BEQ.N    ??DFS_OpenDir_8
//  553 			DFS_CanonicalToDir(tmpfn, ptr);
        MOVS     R7,R4
        ADD      R8,SP,#+0
        MOVS     R2,#+32
        MOVS     R1,#+11
        ADD      R0,SP,#+0
        BL       __aeabi_memset4
        MOVS     R0,#+0
        STRB     R0,[SP, #+11]
        ADD      R0,SP,#+0
        B.N      ??DFS_OpenDir_9
??DFS_OpenDir_10:
        CMP      R1,#+123
        BCS.N    ??DFS_OpenDir_11
        LDRB     R1,[R7], #+1
        SUBS     R1,R1,#+32
        STRB     R1,[R8], #+1
??DFS_OpenDir_9:
        LDRB     R1,[R7, #+0]
        CBZ      R1,??DFS_OpenDir_12
        CMP      R1,#+47
        BEQ.N    ??DFS_OpenDir_12
        SUB      R2,R8,R0
        CMP      R2,#+11
        BGE.N    ??DFS_OpenDir_12
        CMP      R1,#+97
        BCS.N    ??DFS_OpenDir_10
        CMP      R1,#+46
        BNE.N    ??DFS_OpenDir_11
        ADDS     R7,R7,#+1
        ADD      R8,SP,#+8
        B.N      ??DFS_OpenDir_9
??DFS_OpenDir_11:
        LDRB     R1,[R7], #+1
        STRB     R1,[R8], #+1
        B.N      ??DFS_OpenDir_9
//  554 
//  555 			de.name[0] = 0;
??DFS_OpenDir_12:
        MOVS     R0,#+0
        STRB     R0,[SP, #+12]
//  556 
//  557 			do {
//  558 				result = DFS_GetNext(volinfo, dirinfo, &de);
//  559 			} while (!result && memcmp(de.name, tmpfn, 11));
??DFS_OpenDir_13:
        ADD      R2,SP,#+12
        MOVS     R1,R6
        MOVS     R0,R5
        BL       DFS_GetNext
        CBNZ     R0,??DFS_OpenDir_14
        MOVS     R2,#+11
        ADD      R1,SP,#+0
        ADD      R0,SP,#+12
        BL       memcmp
        CMP      R0,#+0
        BNE.N    ??DFS_OpenDir_13
//  560 
//  561 			if (!memcmp(de.name, tmpfn, 11) && ((de.attr & ATTR_DIRECTORY) == ATTR_DIRECTORY)) {
??DFS_OpenDir_14:
        MOVS     R2,#+11
        ADD      R1,SP,#+0
        ADD      R0,SP,#+12
        BL       memcmp
        CBNZ     R0,??DFS_OpenDir_15
        LDRB     R0,[SP, #+23]
        TST      R0,#0x10
        BEQ.N    ??DFS_OpenDir_15
//  562 				if (volinfo->filesystem == FAT32) {
        LDRB     R0,[SP, #+38]
        LDRB     R1,[SP, #+39]
        ORR      R0,R0,R1, LSL #+8
        LDRB     R1,[R5, #+1]
        CMP      R1,#+2
        BNE.N    ??DFS_OpenDir_16
//  563 					dirinfo->currentcluster = (uint32_t) de.startclus_l_l |
//  564 					  ((uint32_t) de.startclus_l_h) << 8 |
//  565 					  ((uint32_t) de.startclus_h_l) << 16 |
//  566 					  ((uint32_t) de.startclus_h_h) << 24;
        LDRB     R1,[SP, #+32]
        ORR      R0,R0,R1, LSL #+16
        LDRB     R1,[SP, #+33]
        ORR      R0,R0,R1, LSL #+24
//  567 				}
//  568 				else {
//  569 					dirinfo->currentcluster = (uint32_t) de.startclus_l_l |
//  570 					  ((uint32_t) de.startclus_l_h) << 8;
??DFS_OpenDir_16:
        STR      R0,[R6, #+0]
//  571 				}
//  572 				dirinfo->currentsector = 0;
        MOVS     R1,#+0
        STRB     R1,[R6, #+4]
//  573 				dirinfo->currententry = 0;
        STRB     R1,[R6, #+5]
//  574 
//  575 				if (DFS_ReadSector(volinfo->unit, dirinfo->scratch, volinfo->dataarea + ((dirinfo->currentcluster - 2) * volinfo->secperclus*2), 1))
        MOV      R2,#+512
        LDR      R1,[R5, #+48]
        SUBS     R0,R0,#+2
        LDRB     R3,[R5, #+20]
        MULS     R0,R0,R3
        ADD      R0,R1,R0, LSL #+1
        LSLS     R1,R0,#+9
        LDR      R0,[R6, #+8]
        BL       __Disk_Buff_RD
        B.N      ??DFS_OpenDir_17
//  576 					return DFS_ERRMISC;
//  577 			}
//  578 			else if (!memcmp(de.name, tmpfn, 11) && !(de.attr & ATTR_DIRECTORY))
??DFS_OpenDir_15:
        MOVS     R2,#+11
        ADD      R1,SP,#+0
        ADD      R0,SP,#+12
        BL       memcmp
        CBNZ     R0,??DFS_OpenDir_17
        LDRB     R0,[SP, #+23]
        TST      R0,#0x10
        BNE.N    ??DFS_OpenDir_17
//  579 				return DFS_NOTFOUND;
??DFS_OpenDir_18:
        MOVS     R0,#+3
        B.N      ??DFS_OpenDir_19
//  580 
//  581 			// seek to next item in list
//  582 			while (*ptr != DIR_SEPARATOR && *ptr)
//  583 				ptr++;
??DFS_OpenDir_20:
        ADDS     R4,R4,#+1
??DFS_OpenDir_17:
        LDRB     R0,[R4, #+0]
        CMP      R0,#+47
        BEQ.N    ??DFS_OpenDir_21
        CMP      R0,#+0
        BNE.N    ??DFS_OpenDir_20
//  584 			if (*ptr == DIR_SEPARATOR)
??DFS_OpenDir_21:
        CMP      R0,#+47
        BNE.W    ??DFS_OpenDir_6
//  585 				ptr++;
        ADDS     R4,R4,#+1
        B.N      ??DFS_OpenDir_6
//  586 		}
//  587 
//  588 		if (!dirinfo->currentcluster)
??DFS_OpenDir_8:
        LDR      R0,[R6, #+0]
        CMP      R0,#+0
        BEQ.N    ??DFS_OpenDir_18
//  589 			return DFS_NOTFOUND;
//  590 	}
//  591 	return DFS_OK;
??DFS_OpenDir_3:
        MOVS     R0,#+0
??DFS_OpenDir_19:
        ADD      SP,SP,#+48
        CFI CFA R13+24
        POP      {R4-R8,PC}       ;; return
        CFI EndBlock cfiBlock8
//  592 }
//  593 
//  594 /*
//  595 	Get next entry in opened directory structure. Copies fields into the dirent
//  596 	structure, updates dirinfo. Note that it is the _caller's_ responsibility to
//  597 	handle the '.' and '..' entries.
//  598 	A deleted file will be returned as a NULL entry (first char of filename=0)
//  599 	by this code. Filenames beginning with 0x05 will be translated to 0xE5
//  600 	automatically. Long file name entries will be returned as NULL.
//  601 	returns DFS_EOF if there are no more entries, DFS_OK if this entry is valid,
//  602 	or DFS_ERRMISC for a media error
//  603 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock9 Using cfiCommon0
        CFI Function DFS_GetNext
        THUMB
//  604 uint32_t DFS_GetNext(PVOLINFO volinfo, PDIRINFO dirinfo, PDIRENT dirent)
//  605 {
DFS_GetNext:
        PUSH     {R4-R6,LR}
        CFI R14 Frame(CFA, -4)
        CFI R6 Frame(CFA, -8)
        CFI R5 Frame(CFA, -12)
        CFI R4 Frame(CFA, -16)
        CFI CFA R13+16
        SUB      SP,SP,#+8
        CFI CFA R13+24
        MOVS     R4,R0
        MOVS     R5,R1
        MOVS     R6,R2
//  606 	uint32_t tempint;	// required by DFS_GetFAT
//  607 
//  608 	// Do we need to read the next sector of the directory?
//  609 	if (dirinfo->currententry >= SECTOR_SIZE / sizeof(DIRENT)) 
        LDRB     R0,[R5, #+5]
        CMP      R0,#+16
        BCC.N    ??DFS_GetNext_0
//  610 	{
//  611 		dirinfo->currententry = 0;
        MOVS     R0,#+0
        STRB     R0,[R5, #+5]
//  612 		dirinfo->currentsector++;
        LDRB     R0,[R5, #+4]
        ADDS     R0,R0,#+1
        STRB     R0,[R5, #+4]
//  613 		
//  614 		// Root directory; special case handling 
//  615 		// Note that currentcluster will only ever be zero if both:
//  616 		// (a) this is the root directory, and
//  617 		// (b) we are on a FAT12/16 volume, where the root dir can't be expanded
//  618 		if (dirinfo->currentcluster == 0) 
        LDR      R3,[R5, #+0]
        CBNZ     R3,??DFS_GetNext_1
//  619 		{
//  620 			// Trying to read past end of root directory?
//  621 			if (dirinfo->currentsector * (SECTOR_SIZE / sizeof(DIRENT)) >= volinfo->rootentries)
        UXTB     R0,R0
        LSLS     R1,R0,#+4
        LDRH     R2,[R4, #+32]
        CMP      R1,R2
        BCC.N    ??DFS_GetNext_2
//  622 				return DFS_EOF;
??DFS_GetNext_3:
        MOVS     R0,#+1
        B.N      ??DFS_GetNext_4
//  623 
//  624 			// Otherwise try to read the next sector
//  625 			return (DFS_ReadSector(volinfo->unit, dirinfo->scratch, volinfo->rootdir + dirinfo->currentsector, 1));
??DFS_GetNext_2:
        MOV      R2,#+512
        LDR      R1,[R4, #+44]
        ADDS     R0,R0,R1
        LSLS     R1,R0,#+9
        LDR      R0,[R5, #+8]
        BL       __Disk_Buff_RD
        B.N      ??DFS_GetNext_5
//  626 		}
//  627 
//  628 		// Normal handling
//  629 		else 
//  630 		{
//  631 			if (dirinfo->currentsector >= volinfo->secperclus) 
??DFS_GetNext_1:
        LDRB     R1,[R4, #+20]
        UXTB     R0,R0
        CMP      R0,R1
        BCC.N    ??DFS_GetNext_6
//  632 			{
//  633 				dirinfo->currentsector = 0;
        MOVS     R0,#+0
        STRB     R0,[R5, #+4]
//  634 				if ((dirinfo->currentcluster >= 0xff7 &&  volinfo->filesystem == FAT12) ||
//  635 				  (dirinfo->currentcluster >= 0xfff7 &&  volinfo->filesystem == FAT16) ||
//  636 				  (dirinfo->currentcluster >= 0x0ffffff7 &&  volinfo->filesystem == FAT32)) 
        MOVW     R0,#+4087
        CMP      R3,R0
        BCC.N    ??DFS_GetNext_7
        LDRB     R0,[R4, #+1]
        CBZ      R0,??DFS_GetNext_8
??DFS_GetNext_7:
        MOVW     R0,#+65527
        CMP      R3,R0
        BCC.N    ??DFS_GetNext_9
        LDRB     R0,[R4, #+1]
        CMP      R0,#+1
        BEQ.N    ??DFS_GetNext_8
??DFS_GetNext_9:
        LDR.W    R0,??DataTable6  ;; 0xffffff7
        CMP      R3,R0
        BCC.N    ??DFS_GetNext_10
        LDRB     R0,[R4, #+1]
        CMP      R0,#+2
        BNE.N    ??DFS_GetNext_10
//  637 				 {
//  638 				  
//  639 				  	// We are at the end of the directory chain. If this is a normal
//  640 				  	// find operation, we should indicate that there is nothing more
//  641 				  	// to see.
//  642 				  	if (!(dirinfo->flags & DFS_DI_BLANKENT))
??DFS_GetNext_8:
        LDRB     R0,[R5, #+12]
        TST      R0,#0x1
        BEQ.N    ??DFS_GetNext_3
//  643 						return DFS_EOF;
//  644 					
//  645 					// On the other hand, if this is a "find free entry" search,
//  646 					// we need to tell the caller to allocate a new cluster
//  647 					else
//  648 						return DFS_ALLOCNEW;
??DFS_GetNext_11:
        MOVS     R0,#+5
        B.N      ??DFS_GetNext_4
//  649 				}
//  650 				dirinfo->currentcluster = DFS_GetFAT(volinfo, dirinfo->scratch, &tempint, dirinfo->currentcluster);
??DFS_GetNext_10:
        ADD      R2,SP,#+0
        LDR      R1,[R5, #+8]
        MOVS     R0,R4
        BL       DFS_GetFAT
        STR      R0,[R5, #+0]
//  651 			}
//  652 			return (DFS_ReadSector(volinfo->unit, dirinfo->scratch, volinfo->dataarea + ((dirinfo->currentcluster - 2) * volinfo->secperclus) + dirinfo->currentsector, 1));
??DFS_GetNext_6:
        MOV      R2,#+512
        LDR      R0,[R4, #+48]
        LDR      R1,[R5, #+0]
        SUBS     R1,R1,#+2
        LDRB     R3,[R4, #+20]
        MLA      R0,R1,R3,R0
        LDRB     R1,[R5, #+4]
        ADDS     R0,R1,R0
        LSLS     R1,R0,#+9
        LDR      R0,[R5, #+8]
        BL       __Disk_Buff_RD
        B.N      ??DFS_GetNext_5
//  653 			
//  654 		}
//  655 	}
//  656 
//  657 	memcpy(dirent, &(((PDIRENT)dirinfo->scratch)[dirinfo->currententry]), sizeof(DIRENT));
??DFS_GetNext_0:
        MOVS     R2,#+32
        LDR      R1,[R5, #+8]
        ADD      R1,R1,R0, LSL #+5
        MOVS     R0,R6
        BL       __aeabi_memcpy
//  658 
//  659 	dirinfo->currententry++;
        LDRB     R0,[R5, #+5]
        ADDS     R0,R0,#+1
        STRB     R0,[R5, #+5]
//  660 	if ((dirent->name[0] == 0) || (dirent->name[0] == 0xe5))
        LDRB     R0,[R6, #+0]
        CBZ      R0,??DFS_GetNext_12
        CMP      R0,#+229
        BNE.N    ??DFS_GetNext_13
//  661 	{		// no more files in this directory
//  662 		// If this is a "find blank" then we can reuse this name.
//  663 		
//  664 		if (dirinfo->flags & DFS_DI_BLANKENT)
??DFS_GetNext_12:
        LDRB     R0,[R5, #+12]
        AND      R1,R0,#0x1
        SUBS     R0,R1,#+1
        SBCS     R0,R0,R0
        LSRS     R0,R0,#+31
//  665 			return DFS_OK;
//  666 		else
//  667 			return DFS_EOF;
        B.N      ??DFS_GetNext_4
//  668 	}
//  669 
//  670 	if (dirent->name[0] == 0xe5)	// handle deleted file entries
//  671 		dirent->name[0] = 0;
//  672 	else if ((dirent->attr & ATTR_LONG_NAME) == ATTR_LONG_NAME)
??DFS_GetNext_13:
        LDRB     R1,[R6, #+11]
        AND      R1,R1,#0xF
        CMP      R1,#+15
        BNE.N    ??DFS_GetNext_14
        MOVS     R0,#+0
        B.N      ??DFS_GetNext_15
//  673 		dirent->name[0] = 0;
//  674 	else if (dirent->name[0] == 0x05)	// handle kanji filenames beginning with 0xE5
??DFS_GetNext_14:
        CMP      R0,#+5
        BNE.N    ??DFS_GetNext_5
//  675 		dirent->name[0] = 0xe5;
        MOVS     R0,#+229
??DFS_GetNext_15:
        STRB     R0,[R6, #+0]
//  676 
//  677 
//  678 	return DFS_OK;
??DFS_GetNext_5:
        MOVS     R0,#+0
??DFS_GetNext_4:
        ADD      SP,SP,#+8
        CFI CFA R13+16
        POP      {R4-R6,PC}       ;; return
        CFI EndBlock cfiBlock9
//  679 }
//  680 
//  681 /*
//  682 	INTERNAL
//  683 	Find a free directory entry in the directory specified by path
//  684 	This function MAY cause a disk write if it is necessary to extend the directory
//  685 	size.
//  686 	Note - di.scratch must be preinitialized to point to a sector scratch buffer
//  687 	de is a scratch structure
//  688 	Returns DFS_ERRMISC if a new entry could not be located or created
//  689 	de is updated with the same return information you would expect from DFS_GetNext
//  690 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock10 Using cfiCommon0
        CFI Function DFS_GetFreeDirEnt
        THUMB
//  691 uint32_t DFS_GetFreeDirEnt(PVOLINFO volinfo, uint8_t *path, PDIRINFO di, PDIRENT de)
//  692 {
DFS_GetFreeDirEnt:
        PUSH     {R4-R10,LR}
        CFI R14 Frame(CFA, -4)
        CFI R10 Frame(CFA, -8)
        CFI R9 Frame(CFA, -12)
        CFI R8 Frame(CFA, -16)
        CFI R7 Frame(CFA, -20)
        CFI R6 Frame(CFA, -24)
        CFI R5 Frame(CFA, -28)
        CFI R4 Frame(CFA, -32)
        CFI CFA R13+32
        SUB      SP,SP,#+8
        CFI CFA R13+40
        MOVS     R5,R0
        MOVS     R6,R2
        MOVS     R4,R3
//  693 	uint32_t tempclus,i;
//  694 
//  695 	if (DFS_OpenDir(volinfo, path, di))
        BL       DFS_OpenDir
        CBZ      R0,??DFS_GetFreeDirEnt_0
//  696 		return DFS_NOTFOUND;
        MOVS     R0,#+3
??DFS_GetFreeDirEnt_1:
        ADD      SP,SP,#+8
        CFI CFA R13+32
        POP      {R4-R10,PC}      ;; return
        CFI CFA R13+40
//  697 
//  698 	// Set "search for empty" flag so DFS_GetNext knows what we're doing
//  699 	di->flags |= DFS_DI_BLANKENT;
??DFS_GetFreeDirEnt_0:
        LDRB     R0,[R6, #+12]
        ORR      R0,R0,#0x1
        STRB     R0,[R6, #+12]
//  700 
//  701 	// We seek through the directory looking for an empty entry
//  702 	// Note we are reusing tempclus as a temporary result holder.
//  703 	tempclus = 0;	
        LDR.W    R9,??DataTable8  ;; 0xffffff8
        LDR.W    R7,??DataTable6  ;; 0xffffff7
//  704 	do {
//  705 		tempclus = DFS_GetNext(volinfo, di, de);
??DFS_GetFreeDirEnt_2:
        MOVS     R2,R4
        MOVS     R1,R6
        MOVS     R0,R5
        BL       DFS_GetNext
//  706 
//  707 		// Empty entry found
//  708 		if (tempclus == DFS_OK && (!de->name[0])) {
        CBNZ     R0,??DFS_GetFreeDirEnt_3
        LDRB     R0,[R4, #+0]
        CMP      R0,#+0
        BNE.N    ??DFS_GetFreeDirEnt_2
//  709 			return DFS_OK;
        B.N      ??DFS_GetFreeDirEnt_1
//  710 		}
//  711 
//  712 		// End of root directory reached
//  713 		else if (tempclus == DFS_EOF)
??DFS_GetFreeDirEnt_3:
        CMP      R0,#+1
        BNE.N    ??DFS_GetFreeDirEnt_4
//  714 			return DFS_ERRMISC;
??DFS_GetFreeDirEnt_5:
        MOV      R0,#-1
        B.N      ??DFS_GetFreeDirEnt_1
//  715 			
//  716 		else if (tempclus == DFS_ALLOCNEW) {
??DFS_GetFreeDirEnt_4:
        CMP      R0,#+5
        BNE.N    ??DFS_GetFreeDirEnt_5
//  717 			tempclus = DFS_GetFreeFAT(volinfo, di->scratch);
        LDR      R4,[R6, #+8]
        MOVS     R0,#+0
        STR      R0,[SP, #+4]
        MOV      R8,#+2
        B.N      ??DFS_GetFreeDirEnt_6
??DFS_GetFreeDirEnt_7:
        ADD      R8,R8,#+1
??DFS_GetFreeDirEnt_6:
        LDR      R0,[R5, #+36]
        CMP      R8,R0
        BCS.N    ??DFS_GetFreeDirEnt_5
        MOV      R3,R8
        ADD      R2,SP,#+4
        MOVS     R1,R4
        MOVS     R0,R5
        BL       DFS_GetFAT
        CMP      R0,#+0
        BNE.N    ??DFS_GetFreeDirEnt_7
//  718 			if (tempclus == 0x0ffffff7)
        CMP      R8,R7
        BEQ.N    ??DFS_GetFreeDirEnt_5
//  719 				return DFS_ERRMISC;
//  720 
//  721 			// write out zeroed sectors to the new cluster
//  722 			memset(di->scratch, 0, SECTOR_SIZE);
        MOV      R1,#+512
        LDR      R0,[R6, #+8]
        BL       __aeabi_memclr
//  723 			for (i=0;i<volinfo->secperclus;i++) {
        MOVS     R0,#+0
        STR      R0,[SP, #+0]
        SUB      R4,R8,#+2
        LDRB     R0,[R5, #+20]
        CBZ      R0,??DFS_GetFreeDirEnt_8
//  724 				if (DFS_WriteSector(volinfo->unit, di->scratch, volinfo->dataarea + (((tempclus - 2) * volinfo->secperclus) + i), 1))
??DFS_GetFreeDirEnt_9:
        LDR      R7,[R6, #+8]
        LDR      R0,[R5, #+48]
        LDRB     R1,[R5, #+20]
        MLA      R0,R4,R1,R0
        LDR      R1,[SP, #+0]
        ADDS     R0,R1,R0
        LSL      R10,R0,#+9
        MOV      R1,R10
        MOVS     R0,R7
        BL       __Disk_Buff_WR
        ADD      R1,R10,#+256
        ADD      R0,R7,#+256
        BL       __Disk_Buff_WR
//  725 					
//  726 					return DFS_ERRMISC;
//  727 			}
        LDR      R0,[SP, #+0]
        ADDS     R0,R0,#+1
        STR      R0,[SP, #+0]
        LDRB     R1,[R5, #+20]
        CMP      R0,R1
        BCC.N    ??DFS_GetFreeDirEnt_9
//  728 			// Point old end cluster to newly allocated cluster
//  729 			i = 0;
??DFS_GetFreeDirEnt_8:
        MOVS     R0,#+0
        STR      R0,[SP, #+0]
//  730 			DFS_SetFAT(volinfo, di->scratch, &i, di->currentcluster, tempclus);
        PUSH     {R8,LR}
        CFI CFA R13+48
        LDR      R3,[R6, #+0]
        ADD      R2,SP,#+8
        LDR      R1,[R6, #+8]
        MOVS     R0,R5
        BL       DFS_SetFAT
        ADD      SP,SP,#+8
        CFI CFA R13+40
//  731 
//  732 			// Update DIRINFO so caller knows where to place the new file			
//  733 			di->currentcluster = tempclus;
        STR      R8,[R6, #+0]
//  734 			di->currentsector = 0;
        MOVS     R0,#+0
        STRB     R0,[R6, #+4]
//  735 			di->currententry = 1;	// since the code coming after this expects to subtract 1
        MOVS     R0,#+1
        STRB     R0,[R6, #+5]
//  736 			
//  737 			// Mark newly allocated cluster as end of chain			
//  738 			switch(volinfo->filesystem) {
        LDRB     R0,[R5, #+1]
        CBZ      R0,??DFS_GetFreeDirEnt_10
        CMP      R0,#+1
        BEQ.N    ??DFS_GetFreeDirEnt_11
        CMP      R0,#+2
        BEQ.N    ??DFS_GetFreeDirEnt_12
        B.N      ??DFS_GetFreeDirEnt_5
//  739 				case FAT12:		tempclus = 0xff8;	break;
??DFS_GetFreeDirEnt_10:
        MOVW     R8,#+4088
        B.N      ??DFS_GetFreeDirEnt_13
//  740 				case FAT16:		tempclus = 0xfff8;	break;
??DFS_GetFreeDirEnt_11:
        MOVW     R8,#+65528
        B.N      ??DFS_GetFreeDirEnt_13
//  741 				case FAT32:		tempclus = 0x0ffffff8;	break;
??DFS_GetFreeDirEnt_12:
        MOV      R8,R9
//  742 				default:		return DFS_ERRMISC;
//  743 			}
//  744 			DFS_SetFAT(volinfo, di->scratch, &i, di->currentcluster, tempclus);
??DFS_GetFreeDirEnt_13:
        PUSH     {R8,LR}
        CFI CFA R13+48
        LDR      R3,[R6, #+0]
        ADD      R2,SP,#+8
        LDR      R1,[R6, #+8]
        MOVS     R0,R5
        BL       DFS_SetFAT
        ADD      SP,SP,#+8
        CFI CFA R13+40
        B.N      ??DFS_GetFreeDirEnt_5
        CFI EndBlock cfiBlock10
//  745 		}
//  746 	} while (!tempclus);
//  747 
//  748 	// We shouldn't get here
//  749 	return DFS_ERRMISC;
//  750 }
//  751 
//  752 /*
//  753 	Open a file for reading or writing. You supply populated VOLINFO, a path to the file,
//  754 	mode (DFS_READ or DFS_WRITE) and an empty fileinfo structure. You also need to
//  755 	provide a pointer to a sector-sized scratch buffer.
//  756 	Returns various DFS_* error states. If the result is DFS_OK, fileinfo can be used
//  757 	to access the file from this point on.
//  758 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock11 Using cfiCommon0
        CFI Function DFS_OpenFile
        THUMB
//  759 uint32_t DFS_OpenFile(PVOLINFO volinfo, uint8_t *path, uint8_t mode, uint8_t *scratch, PFILEINFO fileinfo)
//  760 {
DFS_OpenFile:
        PUSH     {R4-R11,LR}
        CFI R14 Frame(CFA, -4)
        CFI R11 Frame(CFA, -8)
        CFI R10 Frame(CFA, -12)
        CFI R9 Frame(CFA, -16)
        CFI R8 Frame(CFA, -20)
        CFI R7 Frame(CFA, -24)
        CFI R6 Frame(CFA, -28)
        CFI R5 Frame(CFA, -32)
        CFI R4 Frame(CFA, -36)
        CFI CFA R13+36
        SUB      SP,SP,#+132
        CFI CFA R13+168
        MOVS     R4,R0
        MOV      R8,R1
        MOVS     R5,R2
        MOVS     R6,R3
        LDR      R7,[SP, #+168]
//  761 	uint8_t tmppath[MAX_PATH];
//  762 	uint8_t filename[12];
//  763 	uint8_t *p;
//  764 	DIRINFO di;
//  765 	DIRENT de;
//  766         int rc;
//  767 	// larwe 2006-09-16 +1 zero out file structure
//  768 	memset(fileinfo, 0, sizeof(FILEINFO));
        MOVS     R1,#+28
        MOVS     R0,R7
        BL       __aeabi_memclr4
//  769 	// save access mode
//  770 	fileinfo->mode = mode;
        STRB     R5,[R7, #+9]
//  771 
//  772 	// Get a local copy of the path. If it's longer than MAX_PATH, abort.
//  773 	strncpy((char *) tmppath, (char *) path, MAX_PATH);
        MOVS     R2,#+64
        MOV      R1,R8
        ADD      R0,SP,#+68
        BL       strncpy
//  774 	tmppath[MAX_PATH - 1] = 0;
        MOVS     R0,#+0
        STRB     R0,[SP, #+131]
//  775 	if (strcmp((char *) path,(char *) tmppath)) {
        ADD      R1,SP,#+68
        MOV      R0,R8
        BL       strcmp
        CBZ      R0,??DFS_OpenFile_0
//  776 		
//  777 		return DFS_PATHLEN;
        MOVS     R0,#+4
        B.N      ??DFS_OpenFile_1
//  778 	}
//  779 
//  780 	// strip leading path separators
//  781 	while (tmppath[0] == DIR_SEPARATOR)
??DFS_OpenFile_0:
        LDRB     R0,[SP, #+68]
        CMP      R0,#+47
        BNE.N    ??DFS_OpenFile_2
//  782 		strcpy((char *) tmppath, (char *) tmppath + 1);
??DFS_OpenFile_3:
        ADD      R1,SP,#+69
        ADD      R0,SP,#+68
        BL       strcpy
        LDRB     R0,[SP, #+68]
        CMP      R0,#+47
        BEQ.N    ??DFS_OpenFile_3
//  783 
//  784 	// Parse filename off the end of the supplied path
//  785 	p = tmppath;
??DFS_OpenFile_2:
        ADD      R11,SP,#+68
//  786 	while (*(p++));
        LDRB     R0,[SP, #+68]
        CBZ      R0,??DFS_OpenFile_4
??DFS_OpenFile_5:
        LDRB     R0,[R11, #+1]!
        CMP      R0,#+0
        BNE.N    ??DFS_OpenFile_5
//  787 
//  788 	p--;
??DFS_OpenFile_4:
        ADD      R8,SP,#+68
        B.N      ??DFS_OpenFile_6
//  789 	while (p > tmppath && *p != DIR_SEPARATOR) // larwe 9/16/06 ">=" to ">" bugfix
??DFS_OpenFile_7:
        LDRB     R0,[R11, #+0]
        CMP      R0,#+47
        BEQ.N    ??DFS_OpenFile_8
//  790 		p--;
        SUB      R11,R11,#+1
??DFS_OpenFile_6:
        CMP      R8,R11
        BCC.N    ??DFS_OpenFile_7
//  791 	if (*p == DIR_SEPARATOR)
        LDRB     R0,[R11, #+0]
        CMP      R0,#+47
        BNE.N    ??DFS_OpenFile_9
//  792 		p++;
??DFS_OpenFile_8:
        ADD      R11,R11,#+1
//  793 
//  794 	DFS_CanonicalToDir(filename, p);
??DFS_OpenFile_9:
        MOV      R9,R11
        ADD      R10,SP,#+52
        MOVS     R2,#+32
        MOVS     R1,#+11
        ADD      R0,SP,#+52
        BL       __aeabi_memset4
        MOVS     R0,#+0
        STRB     R0,[SP, #+63]
        ADD      R0,SP,#+52
        B.N      ??DFS_OpenFile_10
??DFS_OpenFile_11:
        CMP      R1,#+123
        BCS.N    ??DFS_OpenFile_12
        LDRB     R1,[R9], #+1
        SUBS     R1,R1,#+32
        STRB     R1,[R10], #+1
??DFS_OpenFile_10:
        LDRB     R1,[R9, #+0]
        CBZ      R1,??DFS_OpenFile_13
        CMP      R1,#+47
        BEQ.N    ??DFS_OpenFile_13
        SUB      R2,R10,R0
        CMP      R2,#+11
        BGE.N    ??DFS_OpenFile_13
        CMP      R1,#+97
        BCS.N    ??DFS_OpenFile_11
        CMP      R1,#+46
        BNE.N    ??DFS_OpenFile_12
        ADD      R9,R9,#+1
        ADD      R10,SP,#+60
        B.N      ??DFS_OpenFile_10
??DFS_OpenFile_12:
        LDRB     R1,[R9], #+1
        STRB     R1,[R10], #+1
        B.N      ??DFS_OpenFile_10
//  795 
//  796 	if (p > tmppath)
??DFS_OpenFile_13:
        CMP      R8,R11
        IT       CC 
//  797 		p--;
        SUBCC    R11,R11,#+1
//  798 	if (*p == DIR_SEPARATOR || p == tmppath) // larwe 9/16/06 +"|| p == tmppath" bugfix
        LDRB     R0,[R11, #+0]
        CMP      R0,#+47
        BEQ.N    ??DFS_OpenFile_14
        ADD      R0,SP,#+68
        CMP      R11,R0
        BNE.N    ??DFS_OpenFile_15
//  799 		*p = 0;
??DFS_OpenFile_14:
        MOVS     R0,#+0
        STRB     R0,[R11, #+0]
//  800 
//  801 	// At this point, if our path was MYDIR/MYDIR2/FILE.EXT, filename = "FILE    EXT" and
//  802 	// tmppath = "MYDIR/MYDIR2".
//  803 	
//  804 	di.scratch =scratch ;
??DFS_OpenFile_15:
        STR      R6,[SP, #+40]
//  805 	if (DFS_OpenDir(volinfo,tmppath, &di))//scratch di=dirinfo
        ADD      R2,SP,#+32
        ADD      R1,SP,#+68
        MOVS     R0,R4
        BL       DFS_OpenDir
        CBZ      R0,??DFS_OpenFile_16
//  806 		return DFS_NOTFOUND;
??DFS_OpenFile_17:
        MOVS     R0,#+3
        B.N      ??DFS_OpenFile_1
//  807 
//  808 	while(1) 
//  809 	{
//  810 		rc=DFS_GetNext(volinfo, &di, &de);
??DFS_OpenFile_16:
        ADD      R2,SP,#+0
        ADD      R1,SP,#+32
        MOVS     R0,R4
        BL       DFS_GetNext
//  811 		if(rc==DFS_EOF)break;
        CMP      R0,#+1
        BNE.N    ??DFS_OpenFile_18
//  812 		if (!memcmp(de.name, filename, 11)) 
//  813 		{
//  814 			// You can't use this function call to open a directory.
//  815 			if (de.attr & ATTR_DIRECTORY)
//  816 				return DFS_NOTFOUND;
//  817 
//  818 			fileinfo->volinfo = volinfo;
//  819 			fileinfo->pointer = 0;
//  820 			// The reason we store this extra info about the file is so that we can
//  821 			// speedily update the file size, modification date, etc. on a file that is
//  822 			// opened for writing.
//  823 			if (di.currentcluster == 0)
//  824 				fileinfo->dirsector = volinfo->rootdir + di.currentsector;
//  825 			else
//  826 				fileinfo->dirsector = volinfo->dataarea + (((di.currentcluster - 2) * volinfo->secperclus * (volinfo->sectorsize/SECTOR_SIZE)) + di.currentsector);
//  827 			
//  828 
//  829 			fileinfo->diroffset = di.currententry - 1;
//  830 			if (volinfo->filesystem == FAT32) {
//  831 				fileinfo->cluster = (uint32_t) de.startclus_l_l |
//  832 				  ((uint32_t) de.startclus_l_h) << 8 |
//  833 				  ((uint32_t) de.startclus_h_l) << 16 |
//  834 				  ((uint32_t) de.startclus_h_h) << 24;
//  835 			}
//  836 			else {
//  837 				fileinfo->cluster = (uint32_t) de.startclus_l_l |
//  838 				  ((uint32_t) de.startclus_l_h) << 8;
//  839 			}
//  840 			
//  841  
//  842 				fileinfo->firstcluster = fileinfo->cluster;
//  843 				fileinfo->filelen = (uint32_t) de.filesize_0 |
//  844 			  ((uint32_t) de.filesize_1) << 8 |
//  845 			  ((uint32_t) de.filesize_2) << 16 |
//  846 			  ((uint32_t) de.filesize_3) << 24;
//  847 			if(fileinfo->mode==DFS_WRITE)fileinfo->mode=DFS_MODIFLY;
//  848 			return DFS_OK;
//  849 		}
//  850 		
//  851 	};
//  852 	
//  853 
//  854 	// At this point, we KNOW the file does not exist. If the file was opened
//  855 	// with write access, we can create it.
//  856 	if ((mode & DFS_WRITE)==DFS_WRITE) 
        TST      R5,#0x2
        BEQ.N    ??DFS_OpenFile_17
//  857 	{
//  858 		uint32_t cluster, temp;
//  859 		// Locate or create a directory entry for this file
//  860 		if (DFS_OK != DFS_GetFreeDirEnt(volinfo, tmppath, &di, &de))
        ADD      R3,SP,#+0
        ADD      R2,SP,#+32
        ADD      R1,SP,#+68
        MOVS     R0,R4
        BL       DFS_GetFreeDirEnt
        CMP      R0,#+0
        BEQ.N    ??DFS_OpenFile_19
//  861 			return 	DFS_ERRMISC;
??DFS_OpenFile_20:
        MOV      R0,#-1
        B.N      ??DFS_OpenFile_1
??DFS_OpenFile_18:
        MOVS     R2,#+11
        ADD      R1,SP,#+52
        ADD      R0,SP,#+0
        BL       memcmp
        CMP      R0,#+0
        BNE.N    ??DFS_OpenFile_16
        LDRB     R0,[SP, #+11]
        TST      R0,#0x10
        BNE.N    ??DFS_OpenFile_17
        STR      R4,[R7, #+0]
        MOVS     R0,#+0
        STR      R0,[R7, #+24]
        LDRB     R0,[SP, #+36]
        LDR      R1,[SP, #+32]
        CBNZ     R1,??DFS_OpenFile_21
        LDR      R1,[R4, #+44]
        B.N      ??DFS_OpenFile_22
??DFS_OpenFile_21:
        LDR      R1,[R4, #+48]
        LDR      R2,[SP, #+32]
        SUBS     R2,R2,#+2
        LDRB     R3,[R4, #+20]
        MULS     R2,R2,R3
        LDRH     R3,[R4, #+52]
        LSRS     R3,R3,#+9
        MLA      R1,R2,R3,R1
??DFS_OpenFile_22:
        ADDS     R0,R0,R1
        STR      R0,[R7, #+4]
        LDRB     R0,[SP, #+37]
        SUBS     R0,R0,#+1
        STRB     R0,[R7, #+8]
        LDRB     R0,[SP, #+26]
        LDRB     R1,[SP, #+27]
        ORR      R0,R0,R1, LSL #+8
        LDRB     R1,[R4, #+1]
        CMP      R1,#+2
        BNE.N    ??DFS_OpenFile_23
        LDRB     R1,[SP, #+20]
        ORR      R0,R0,R1, LSL #+16
        LDRB     R1,[SP, #+21]
        ORR      R0,R0,R1, LSL #+24
??DFS_OpenFile_23:
        STR      R0,[R7, #+20]
        STR      R0,[R7, #+12]
        LDRB     R0,[SP, #+28]
        LDRB     R1,[SP, #+29]
        ORR      R0,R0,R1, LSL #+8
        LDRB     R1,[SP, #+30]
        ORR      R0,R0,R1, LSL #+16
        LDRB     R1,[SP, #+31]
        ORR      R0,R0,R1, LSL #+24
        STR      R0,[R7, #+16]
        LDRB     R0,[R7, #+9]
        CMP      R0,#+2
        BNE.W    ??DFS_OpenFile_24
        MOVS     R0,#+3
        STRB     R0,[R7, #+9]
??DFS_OpenFile_25:
        B.N      ??DFS_OpenFile_24
//  862 		
//  863 
//  864 		// put sane values in the directory entry
//  865 		memset(&de, 0, sizeof(de));
??DFS_OpenFile_19:
        MOVS     R1,#+32
        ADD      R0,SP,#+0
        BL       __aeabi_memclr4
//  866 		memcpy(de.name, filename, 11);
        MOVS     R2,#+11
        ADD      R1,SP,#+52
        ADD      R0,SP,#+0
        BL       __aeabi_memcpy4
//  867 		//de.crttimetenth=0;
//  868 		de.crttime_l = 0;	// 01:01:00am, Jan 1, 2006.
        MOVS     R0,#+0
        STRH     R0,[SP, #+14]
//  869 		de.crttime_h = 0;//0X40;
//  870 		de.crtdate_l = 0;//0XA1;
        STRH     R0,[SP, #+16]
//  871 		de.crtdate_h = 0;//0X3E;
//  872 		//de.lstaccdate_l = 11;
//  873 		//de.lstaccdate_h = 34;
//  874 		
//  875 		de.wrttime_l = 0;			//2011/05/01
        STRH     R0,[SP, #+22]
//  876 		de.wrttime_h = 0;//0X40;
//  877 		de.wrtdate_l = 0;//0XA1;
        STRH     R0,[SP, #+24]
//  878 		de.wrtdate_h = 0;//0X3E;
//  879 
//  880 		// allocate a starting cluster for the directory entry
//  881 		cluster = DFS_GetFreeFAT(volinfo, scratch);
        STR      R0,[SP, #+64]
        MOVS     R5,#+2
        B.N      ??DFS_OpenFile_26
??DFS_OpenFile_27:
        ADDS     R5,R5,#+1
??DFS_OpenFile_26:
        LDR      R0,[R4, #+36]
        CMP      R5,R0
        BCS.N    ??DFS_OpenFile_28
        MOVS     R3,R5
        ADD      R2,SP,#+64
        MOVS     R1,R6
        MOVS     R0,R4
        BL       DFS_GetFAT
        CMP      R0,#+0
        BNE.N    ??DFS_OpenFile_27
        B.N      ??DFS_OpenFile_29
??DFS_OpenFile_28:
        LDR.N    R5,??DataTable6  ;; 0xffffff7
//  882 
//  883 		de.startclus_l_l = cluster & 0xff;
??DFS_OpenFile_29:
        ADD      R0,SP,#+0
        STRB     R5,[R0, #+26]
//  884 		de.startclus_l_h = (cluster & 0xff00) >> 8;
        LSRS     R0,R5,#+8
        STRB     R0,[SP, #+27]
//  885 		de.startclus_h_l = (cluster & 0xff0000) >> 16;
        LSRS     R0,R5,#+16
        STRB     R0,[SP, #+20]
//  886 		de.startclus_h_h = (cluster & 0xff000000) >> 24;
        LSRS     R0,R5,#+24
        STRB     R0,[SP, #+21]
//  887 		
//  888 		
//  889 		// update FILEINFO for our caller's sake
//  890 		fileinfo->volinfo = volinfo;
        STR      R4,[R7, #+0]
//  891 		fileinfo->pointer = 0;
        MOVS     R0,#+0
        STR      R0,[R7, #+24]
//  892 		// The reason we store this extra info about the file is so that we can
//  893 		// speedily update the file size, modification date, etc. on a file that is
//  894 		// opened for writing.
//  895 		if (di.currentcluster == 0)
        LDRB     R0,[SP, #+36]
        LDR      R1,[SP, #+32]
        CBNZ     R1,??DFS_OpenFile_30
//  896 			fileinfo->dirsector = volinfo->rootdir + di.currentsector;
        LDR      R1,[R4, #+44]
        B.N      ??DFS_OpenFile_31
//  897 		else
//  898 			fileinfo->dirsector = volinfo->dataarea + ((di.currentcluster - 2) * volinfo->secperclus*(volinfo->sectorsize/SECTOR_SIZE) ) + di.currentsector;
??DFS_OpenFile_30:
        LDR      R1,[R4, #+48]
        LDR      R2,[SP, #+32]
        SUBS     R2,R2,#+2
        LDRB     R3,[R4, #+20]
        MULS     R2,R2,R3
        LDRH     R3,[R4, #+52]
        LSRS     R3,R3,#+9
        MLA      R1,R2,R3,R1
??DFS_OpenFile_31:
        ADDS     R0,R0,R1
        STR      R0,[R7, #+4]
//  899 		
//  900 		fileinfo->diroffset = di.currententry - 1;
        LDRB     R1,[SP, #+37]
        SUBS     R1,R1,#+1
        STRB     R1,[R7, #+8]
//  901 		//dirsec=fileinfo->dirsector;
//  902 		//diroff=fileinfo->diroffset;
//  903 		fileinfo->cluster = cluster;
        STR      R5,[R7, #+20]
//  904 		fileinfo->firstcluster = cluster;
        STR      R5,[R7, #+12]
//  905 		
//  906 		fileinfo->filelen = 0;
        MOVS     R1,#+0
        STR      R1,[R7, #+16]
//  907 		// write the directory entry
//  908 		// note that we no longer have the sector containing the directory entry,
//  909 		// tragically, so we have to re-read it
//  910 		if (DFS_ReadSector(volinfo->unit, scratch, fileinfo->dirsector, 1))
        MOV      R2,#+512
        LSLS     R1,R0,#+9
        MOVS     R0,R6
        BL       __Disk_Buff_RD
//  911 		
//  912 			return DFS_ERRMISC;
//  913 		memcpy(&(((PDIRENT) scratch)[di.currententry-1]), &de, sizeof(DIRENT));
        MOVS     R2,#+32
        ADD      R1,SP,#+0
        LDRB     R0,[SP, #+37]
        ADD      R0,R6,R0, LSL #+5
        SUBS     R0,R0,#+32
        BL       __aeabi_memcpy
//  914 		if (DFS_WriteSector(volinfo->unit, scratch, fileinfo->dirsector, 1))
        LDR      R0,[R7, #+4]
        LSLS     R5,R0,#+9
        MOVS     R1,R5
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R5,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
//  915 			return DFS_ERRMISC;
//  916 
//  917 		// Mark newly allocated cluster as end of chain			
//  918 		switch(volinfo->filesystem) {
        LDRB     R0,[R4, #+1]
        CBZ      R0,??DFS_OpenFile_32
        CMP      R0,#+1
        BEQ.N    ??DFS_OpenFile_33
        CMP      R0,#+2
        BEQ.N    ??DFS_OpenFile_34
        B.N      ??DFS_OpenFile_20
//  919 			case FAT12:		cluster = 0xff8;	break;
??DFS_OpenFile_32:
        MOVW     R5,#+4088
        B.N      ??DFS_OpenFile_35
//  920 			case FAT16:		cluster = 0xfff8;	break;
??DFS_OpenFile_33:
        MOVW     R5,#+65528
        B.N      ??DFS_OpenFile_35
//  921 			case FAT32:		cluster = 0x0ffffff8;	break;
??DFS_OpenFile_34:
        LDR.N    R5,??DataTable8  ;; 0xffffff8
//  922 			default:		return DFS_ERRMISC;
//  923 		}
//  924 		temp = 0;
??DFS_OpenFile_35:
        MOVS     R0,#+0
        STR      R0,[SP, #+48]
//  925 		DFS_SetFAT(volinfo, scratch, &temp, fileinfo->cluster, cluster);
        PUSH     {R5,LR}
        CFI CFA R13+176
        LDR      R3,[R7, #+20]
        ADD      R2,SP,#+56
        MOVS     R1,R6
        MOVS     R0,R4
        BL       DFS_SetFAT
        ADD      SP,SP,#+8
        CFI CFA R13+168
//  926 
//  927 		return DFS_OK;
??DFS_OpenFile_24:
        MOVS     R0,#+0
??DFS_OpenFile_1:
        ADD      SP,SP,#+132
        CFI CFA R13+36
        POP      {R4-R11,PC}      ;; return
        CFI EndBlock cfiBlock11
//  928 	}
//  929 
//  930 
//  931 	return DFS_NOTFOUND;
//  932 }

        SECTION `.text`:CODE:NOROOT(2)
        DATA
??DataTable6:
        DC32     0xffffff7
//  933 
//  934 /*
//  935 	Read an open file
//  936 	You must supply a prepopulated FILEINFO as provided by DFS_OpenFile, and a
//  937 	pointer to a SECTOR_SIZE scratch buffer.
//  938 	Note that returning DFS_EOF is not an error condition. This function updates the
//  939 	successcount field with the number of bytes actually read.
//  940 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock12 Using cfiCommon0
        CFI Function DFS_ReadFile
        THUMB
//  941 uint32_t DFS_ReadFile(PFILEINFO fileinfo, uint8_t *scratch, uint8_t *buffer, uint32_t *successcount, uint32_t len)
//  942 {
DFS_ReadFile:
        PUSH     {R4-R10,LR}
        CFI R14 Frame(CFA, -4)
        CFI R10 Frame(CFA, -8)
        CFI R9 Frame(CFA, -12)
        CFI R8 Frame(CFA, -16)
        CFI R7 Frame(CFA, -20)
        CFI R6 Frame(CFA, -24)
        CFI R5 Frame(CFA, -28)
        CFI R4 Frame(CFA, -32)
        CFI CFA R13+32
        SUB      SP,SP,#+24
        CFI CFA R13+56
        MOVS     R4,R0
        MOVS     R5,R1
        MOVS     R6,R2
        MOV      R9,R3
        LDR      R7,[SP, #+56]
//  943 	uint32_t remain;
//  944 	uint32_t result = DFS_OK;
//  945 	uint32_t sector;
//  946 	uint32_t bytesread;
//  947 uint16_t tempreadsize;
//  948 	// Don't try to read past EOF
//  949 	if (len > fileinfo->filelen - fileinfo->pointer)
        LDR      R0,[R4, #+16]
        LDR      R1,[R4, #+24]
        SUBS     R0,R0,R1
        CMP      R0,R7
        IT       CC 
//  950 		len = fileinfo->filelen - fileinfo->pointer;
        MOVCC    R7,R0
//  951 
//  952 	remain = len;
//  953 	*successcount = 0;
        MOVS     R0,#+0
        STR      R0,[R9, #+0]
        MOVW     R10,#+4088
        B.N      ??DFS_ReadFile_0
//  954 	
//  955 	while (remain && result == DFS_OK) 
//  956 	{
//  957 			
//  958 		// This is a bit complicated. The sector we want to read is addressed at a cluster
//  959 		// granularity by the fileinfo->cluster member. The file pointer tells us how many
//  960 		// extra sectors to add to that number.*2*2
//  961 		sector = fileinfo->volinfo->dataarea +
//  962 		  ((fileinfo->cluster - 2) * fileinfo->volinfo->secperclus*(fileinfo->volinfo->sectorsize/SECTOR_SIZE)) +
//  963 		 div(div(fileinfo->pointer,fileinfo->volinfo->secperclus *fileinfo->volinfo->sectorsize).rem, SECTOR_SIZE).quot;
//  964 
//  965 
//  966 		// Case 1 - File pointer is not on a sector boundary
//  967 		if (div(fileinfo->pointer, SECTOR_SIZE).rem) 
//  968 		{
//  969 			
//  970 			// We always have to go through scratch in this case
//  971 			result = DFS_ReadSector(fileinfo->volinfo->unit, scratch, sector, 1);
//  972 			// This is the number of bytes that we actually care about in the sector
//  973 			// just read.
//  974 			tempreadsize = SECTOR_SIZE - (div(fileinfo->pointer, SECTOR_SIZE).rem);
//  975 					
//  976 			// Case 1A - We want the entire remainder of the sector. After this
//  977 			// point, all passes through the read loop will be aligned on a sector
//  978 			// boundary, which allows us to go through the optimal path 2A below.
//  979 		   	if (remain >= tempreadsize) 
//  980 		   	{
//  981 				memcpy(buffer, scratch + (SECTOR_SIZE - tempreadsize), tempreadsize);
//  982 				bytesread = tempreadsize;
//  983 				buffer += tempreadsize;
//  984 				fileinfo->pointer += tempreadsize;
//  985 				remain -= tempreadsize;
//  986 			}
//  987 			// Case 1B - This read concludes the file read operation
//  988 			else {
//  989 				memcpy(buffer, scratch + (SECTOR_SIZE - tempreadsize), remain);
//  990 
//  991 				buffer += remain;
//  992 				fileinfo->pointer += remain;
//  993 				bytesread = remain;
//  994 				remain = 0;
//  995 			}
//  996 		}
//  997 		// Case 2 - File pointer is on sector boundary
//  998 		else {
//  999 			// Case 2A - We have at least one more full sector to read and don't have
// 1000 			// to go through the scratch buffer. You could insert optimizations here to
// 1001 			// read multiple sectors at a time, if you were thus inclined (note that
// 1002 			// the maximum multi-read you could perform is a single cluster, so it would
// 1003 			// be advantageous to have code similar to case 1A above that would round the
// 1004 			// pointer to a cluster boundary the first pass through, so all subsequent
// 1005 			// [large] read requests would be able to go a cluster at a time).
// 1006 			if (remain >= SECTOR_SIZE) {
// 1007 				result = DFS_ReadSector(fileinfo->volinfo->unit, buffer, sector, 1);
// 1008 
// 1009 				remain -= SECTOR_SIZE;
// 1010 				buffer += SECTOR_SIZE;
// 1011 				fileinfo->pointer += SECTOR_SIZE;
// 1012 				bytesread = SECTOR_SIZE;
// 1013 			}
// 1014 			// Case 2B - We are only reading a partial sector
// 1015 			else {
// 1016 				result = DFS_ReadSector(fileinfo->volinfo->unit, scratch, sector, 1);
??DFS_ReadFile_1:
        MOV      R2,#+512
        MOVS     R0,R5
        BL       __Disk_Buff_RD
// 1017 			
// 1018 				memcpy(buffer, scratch, remain);
        MOVS     R2,R7
        MOVS     R1,R5
??DFS_ReadFile_2:
        MOVS     R0,R6
        BL       __aeabi_memcpy
// 1019 				buffer += remain;
        ADDS     R6,R7,R6
// 1020 				fileinfo->pointer += remain;
        LDR      R0,[R4, #+24]
        ADDS     R0,R7,R0
        STR      R0,[R4, #+24]
// 1021 				bytesread = remain;
        STR      R7,[SP, #+0]
// 1022 				remain = 0;
        MOVS     R7,#+0
// 1023 				
// 1024 			}
// 1025 		}
// 1026 
// 1027 		*successcount += bytesread;
??DFS_ReadFile_3:
        LDR      R0,[R9, #+0]
        LDR      R1,[SP, #+0]
        ADDS     R0,R1,R0
        STR      R0,[R9, #+0]
// 1028 
// 1029 		// check to see if we stepped over a cluster boundary
// 1030 		if (div(fileinfo->pointer - bytesread, fileinfo->volinfo->secperclus *fileinfo->volinfo->sectorsize).quot !=
// 1031 		  div(fileinfo->pointer, fileinfo->volinfo->secperclus * fileinfo->volinfo->sectorsize).quot) {
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+20]
        LDRH     R0,[R0, #+52]
        MUL      R2,R1,R0
        LDR      R0,[R4, #+24]
        LDR      R1,[SP, #+0]
        SUBS     R1,R0,R1
        ADD      R0,SP,#+4
        BL       div
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+20]
        LDRH     R0,[R0, #+52]
        MUL      R2,R1,R0
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+12
        BL       div
        LDR      R0,[SP, #+4]
        LDR      R1,[SP, #+12]
        CMP      R0,R1
        BEQ.N    ??DFS_ReadFile_0
// 1032 			// An act of minor evil - we use bytesread as a scratch integer, knowing that
// 1033 			// its value is not used after updating *successcount above
// 1034 			bytesread = 0;
        MOVS     R0,#+0
        STR      R0,[SP, #+0]
// 1035 			
// 1036 			if (((fileinfo->volinfo->filesystem == FAT12) && (fileinfo->cluster >= 0xff8)) ||
// 1037 			  ((fileinfo->volinfo->filesystem == FAT16) && (fileinfo->cluster >= 0xfff8)) ||
// 1038 			  ((fileinfo->volinfo->filesystem == FAT32) && (fileinfo->cluster >= 0x0ffffff8)))
        LDR      R3,[R4, #+20]
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+1]
        CBNZ     R1,??DFS_ReadFile_4
        CMP      R3,R10
        BCS.N    ??DFS_ReadFile_0
??DFS_ReadFile_4:
        CMP      R1,#+1
        BNE.N    ??DFS_ReadFile_5
        MOVW     R1,#+65528
        CMP      R3,R1
        BCS.N    ??DFS_ReadFile_0
??DFS_ReadFile_5:
        LDRB     R1,[R0, #+1]
        CMP      R1,#+2
        BNE.N    ??DFS_ReadFile_6
        LDR.N    R1,??DataTable8  ;; 0xffffff8
        CMP      R3,R1
        BCS.N    ??DFS_ReadFile_0
// 1039 				result =0;
// 1040 			else
// 1041 				fileinfo->cluster = DFS_GetFAT(fileinfo->volinfo, scratch, &bytesread, fileinfo->cluster);
??DFS_ReadFile_6:
        ADD      R2,SP,#+0
        MOVS     R1,R5
        BL       DFS_GetFAT
        STR      R0,[R4, #+20]
// 1042 		}
??DFS_ReadFile_0:
        CMP      R7,#+0
        BEQ.N    ??DFS_ReadFile_7
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+20]
        LDRH     R0,[R0, #+52]
        MUL      R2,R1,R0
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+12
        BL       div
        MOV      R2,#+512
        LDR      R1,[SP, #+16]
        ADD      R0,SP,#+4
        BL       div
        LDR      R0,[R4, #+0]
        LDR      R1,[R0, #+48]
        LDR      R2,[R4, #+20]
        SUBS     R2,R2,#+2
        LDRB     R3,[R0, #+20]
        MULS     R2,R2,R3
        LDRH     R0,[R0, #+52]
        LSRS     R0,R0,#+9
        MLA      R0,R2,R0,R1
        LDR      R1,[SP, #+4]
        ADD      R8,R1,R0
        MOV      R2,#+512
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+4
        BL       div
        LSL      R1,R8,#+9
        LDR      R0,[SP, #+8]
        CMP      R0,#+0
        BEQ.N    ??DFS_ReadFile_8
        MOV      R2,#+512
        MOVS     R0,R5
        BL       __Disk_Buff_RD
        MOV      R2,#+512
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+4
        BL       div
        LDR      R0,[SP, #+8]
        RSB      R8,R0,#+512
        UXTH     R8,R8
        RSB      R0,R8,#+0
        ADDS     R0,R0,R5
        CMP      R7,R8
        BCC.N    ??DFS_ReadFile_9
        MOV      R2,R8
        ADD      R1,R0,#+512
        MOVS     R0,R6
        BL       __aeabi_memcpy
        STR      R8,[SP, #+0]
        ADD      R6,R8,R6
        LDR      R0,[R4, #+24]
        ADD      R0,R8,R0
        STR      R0,[R4, #+24]
        SUB      R7,R7,R8
        B.N      ??DFS_ReadFile_3
??DFS_ReadFile_9:
        MOVS     R2,R7
        ADD      R1,R0,#+512
        B.N      ??DFS_ReadFile_2
??DFS_ReadFile_8:
        CMP      R7,#+512
        BCC.W    ??DFS_ReadFile_1
        MOV      R2,#+512
        MOVS     R0,R6
        BL       __Disk_Buff_RD
        SUB      R7,R7,#+512
        ADD      R6,R6,#+512
        LDR      R0,[R4, #+24]
        ADD      R0,R0,#+512
        STR      R0,[R4, #+24]
        MOV      R0,#+512
        STR      R0,[SP, #+0]
        B.N      ??DFS_ReadFile_3
// 1043 	}
// 1044 	
// 1045 	return result;
??DFS_ReadFile_7:
        MOVS     R0,#+0
        ADD      SP,SP,#+24
        CFI CFA R13+32
        POP      {R4-R10,PC}      ;; return
        CFI EndBlock cfiBlock12
// 1046 }

        SECTION `.text`:CODE:NOROOT(2)
        DATA
??DataTable8:
        DC32     0xffffff8
// 1047 
// 1048 /*
// 1049 	Seek file pointer to a given position
// 1050 	This function does not return status - refer to the fileinfo->pointer value
// 1051 	to see where the pointer wound up.
// 1052 	Requires a SECTOR_SIZE scratch buffer
// 1053 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock13 Using cfiCommon0
        CFI Function DFS_Seek
        THUMB
// 1054 void DFS_Seek(PFILEINFO fileinfo, uint32_t offset, uint8_t *scratch)
// 1055 {
DFS_Seek:
        PUSH     {R4-R7,LR}
        CFI R14 Frame(CFA, -4)
        CFI R7 Frame(CFA, -8)
        CFI R6 Frame(CFA, -12)
        CFI R5 Frame(CFA, -16)
        CFI R4 Frame(CFA, -20)
        CFI CFA R13+20
        SUB      SP,SP,#+20
        CFI CFA R13+40
        MOVS     R4,R0
        MOVS     R5,R1
        MOVS     R6,R2
// 1056 	uint32_t tempint;
// 1057 
// 1058 	// larwe 9/16/06 bugfix split case 0a/0b and changed fallthrough handling
// 1059 	// Case 0a - Return immediately for degenerate case
// 1060 	if (offset == fileinfo->pointer) {
        LDR      R0,[R4, #+24]
        CMP      R5,R0
        BEQ.N    ??DFS_Seek_0
// 1061 		return;
// 1062 	}
// 1063 	
// 1064 	// Case 0b - Don't allow the user to seek past the end of the file
// 1065 	if (offset > fileinfo->filelen) {
        LDR      R1,[R4, #+16]
        CMP      R1,R5
        IT       CC 
// 1066 		offset = fileinfo->filelen;
        MOVCC    R5,R1
// 1067 		// NOTE NO RETURN HERE!
// 1068 	}
// 1069 
// 1070 	// Case 1 - Simple rewind to start
// 1071 	// Note _intentional_ fallthrough from Case 0b above
// 1072 	if (offset == 0) {
        CBNZ     R5,??DFS_Seek_1
// 1073 		fileinfo->cluster = fileinfo->firstcluster;
        LDR      R0,[R4, #+12]
        STR      R0,[R4, #+20]
// 1074 		fileinfo->pointer = 0;
        MOVS     R0,#+0
        STR      R0,[R4, #+24]
// 1075 		return;		// larwe 9/16/06 +1 bugfix
        B.N      ??DFS_Seek_0
// 1076 	}
// 1077 	// Case 2 - Seeking backwards. Need to reset and seek forwards
// 1078 	else if (offset < fileinfo->pointer) {
??DFS_Seek_1:
        CMP      R5,R0
        BCS.N    ??DFS_Seek_2
// 1079 		fileinfo->cluster = fileinfo->firstcluster;
        LDR      R0,[R4, #+12]
        STR      R0,[R4, #+20]
// 1080 		fileinfo->pointer = 0;
        MOVS     R0,#+0
        STR      R0,[R4, #+24]
// 1081 		// NOTE NO RETURN HERE!
// 1082 	}
// 1083 
// 1084 	// Case 3 - Seeking forwards
// 1085 	// Note _intentional_ fallthrough from Case 2 above
// 1086 
// 1087 	// Case 3a - Seek size does not cross cluster boundary - 
// 1088 	// very simple case
// 1089 	// larwe 9/16/06 changed .rem to .quot in both div calls, bugfix
// 1090 	if (div(fileinfo->pointer, fileinfo->volinfo->secperclus * SECTOR_SIZE).quot ==
// 1091 	  div(fileinfo->pointer + offset, fileinfo->volinfo->secperclus * SECTOR_SIZE).quot) {
??DFS_Seek_2:
        LDR      R0,[R4, #+0]
        LDRB     R0,[R0, #+20]
        LSLS     R2,R0,#+9
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+8
        BL       div
        LDR      R0,[R4, #+0]
        LDRB     R0,[R0, #+20]
        LSLS     R2,R0,#+9
        LDR      R0,[R4, #+24]
        ADDS     R1,R5,R0
        ADD      R0,SP,#+0
        BL       div
        LDR      R0,[SP, #+8]
        LDR      R1,[SP, #+0]
        CMP      R0,R1
        BNE.N    ??DFS_Seek_3
// 1092 		fileinfo->pointer = offset;
??DFS_Seek_4:
        STR      R5,[R4, #+24]
        B.N      ??DFS_Seek_0
// 1093 	}
// 1094 	// Case 3b - Seeking across cluster boundary(ies)
// 1095 	else {
// 1096 		// round file pointer down to cluster boundary
// 1097 		fileinfo->pointer = div(fileinfo->pointer, fileinfo->volinfo->secperclus * SECTOR_SIZE).quot *
// 1098 		  fileinfo->volinfo->secperclus * SECTOR_SIZE;
??DFS_Seek_3:
        LDR      R0,[R4, #+0]
        LDRB     R0,[R0, #+20]
        LSLS     R2,R0,#+9
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+0
        BL       div
        LDR      R0,[SP, #+0]
        LDR      R1,[R4, #+0]
        LDRB     R1,[R1, #+20]
        MULS     R0,R0,R1
        LSLS     R0,R0,#+9
        STR      R0,[R4, #+24]
        LDR.N    R7,??DFS_Seek_5  ;; 0xffffff7
        B.N      ??DFS_Seek_6
// 1099 
// 1100 		// seek by clusters
// 1101 		// larwe 9/30/06 bugfix changed .rem to .quot in both div calls
// 1102 		while (div(fileinfo->pointer, fileinfo->volinfo->secperclus * SECTOR_SIZE).quot !=
// 1103 		  div(fileinfo->pointer + offset, fileinfo->volinfo->secperclus * SECTOR_SIZE).quot) {
// 1104 
// 1105 			fileinfo->cluster = DFS_GetFAT(fileinfo->volinfo, scratch, &tempint, fileinfo->cluster);
// 1106 			// Abort if there was an error
// 1107 			if (fileinfo->cluster == 0x0ffffff7) {
// 1108 				fileinfo->pointer = 0;
// 1109 				fileinfo->cluster = fileinfo->firstcluster;
// 1110 				return;
// 1111 			}
// 1112 			fileinfo->pointer += SECTOR_SIZE * fileinfo->volinfo->secperclus;
??DFS_Seek_7:
        LDR      R0,[R4, #+24]
        LDR      R1,[R4, #+0]
        LDRB     R1,[R1, #+20]
        ADD      R0,R0,R1, LSL #+9
        STR      R0,[R4, #+24]
??DFS_Seek_6:
        LDR      R0,[R4, #+0]
        LDRB     R0,[R0, #+20]
        LSLS     R2,R0,#+9
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+0
        BL       div
        LDR      R0,[R4, #+0]
        LDRB     R0,[R0, #+20]
        LSLS     R2,R0,#+9
        LDR      R0,[R4, #+24]
        ADDS     R1,R5,R0
        ADD      R0,SP,#+8
        BL       div
        LDR      R0,[SP, #+0]
        LDR      R1,[SP, #+8]
        CMP      R0,R1
        BEQ.N    ??DFS_Seek_4
        LDR      R3,[R4, #+20]
        ADD      R2,SP,#+16
        MOVS     R1,R6
        LDR      R0,[R4, #+0]
        BL       DFS_GetFAT
        STR      R0,[R4, #+20]
        CMP      R0,R7
        BNE.N    ??DFS_Seek_7
        MOVS     R0,#+0
        STR      R0,[R4, #+24]
        LDR      R0,[R4, #+12]
        STR      R0,[R4, #+20]
??DFS_Seek_0:
        ADD      SP,SP,#+20
        CFI CFA R13+20
        POP      {R4-R7,PC}       ;; return
        DATA
??DFS_Seek_5:
        DC32     0xffffff7
        CFI EndBlock cfiBlock13
// 1113 		}
// 1114 
// 1115 		// since we know the cluster is right, we have no more work to do
// 1116 		fileinfo->pointer = offset;
// 1117 	}
// 1118 }
// 1119 
// 1120 /*
// 1121 	Delete a file
// 1122 	scratch must point to a sector-sized buffer
// 1123 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock14 Using cfiCommon0
        CFI Function DFS_UnlinkFile
        THUMB
// 1124 uint32_t DFS_UnlinkFile(PVOLINFO volinfo, uint8_t *path, uint8_t *scratch)
// 1125 {
DFS_UnlinkFile:
        PUSH     {R4-R9,LR}
        CFI R14 Frame(CFA, -4)
        CFI R9 Frame(CFA, -8)
        CFI R8 Frame(CFA, -12)
        CFI R7 Frame(CFA, -16)
        CFI R6 Frame(CFA, -20)
        CFI R5 Frame(CFA, -24)
        CFI R4 Frame(CFA, -28)
        CFI CFA R13+28
        SUB      SP,SP,#+36
        CFI CFA R13+64
        MOVS     R4,R0
        MOVS     R5,R2
// 1126 	//PDIRENT de = (PDIRENT) scratch;
// 1127 	FILEINFO fi;
// 1128 	uint32_t cache = 0;
        MOVS     R0,#+0
        STR      R0,[SP, #+0]
// 1129 	uint32_t tempclus;
// 1130 
// 1131 	// DFS_OpenFile gives us all the information we need to delete it
// 1132 	if (DFS_OK != DFS_OpenFile(volinfo, path, DFS_READ, scratch, &fi))
        ADD      R0,SP,#+4
        PUSH     {R0,LR}
        CFI CFA R13+72
        MOVS     R3,R5
        MOVS     R2,#+1
        MOVS     R0,R4
        BL       DFS_OpenFile
        ADD      SP,SP,#+8
        CFI CFA R13+64
        CBZ      R0,??DFS_UnlinkFile_0
// 1133 		return DFS_NOTFOUND;
        MOVS     R0,#+3
        B.N      ??DFS_UnlinkFile_1
// 1134 
// 1135 	// First, read the directory sector and delete that entry
// 1136 	if (DFS_ReadSector(volinfo->unit, scratch, fi.dirsector, 1))
??DFS_UnlinkFile_0:
        MOV      R2,#+512
        LDR      R0,[SP, #+8]
        LSLS     R1,R0,#+9
        MOVS     R0,R5
        BL       __Disk_Buff_RD
// 1137 		return DFS_ERRMISC;
// 1138 	((PDIRENT) scratch)[fi.diroffset].name[0] = 0xe5;
        LDRB     R0,[SP, #+12]
        LSLS     R0,R0,#+5
        MOVS     R1,#+229
        STRB     R1,[R0, R5]
// 1139 	if (DFS_WriteSector(volinfo->unit, scratch, fi.dirsector, 1))
        LDR      R0,[SP, #+8]
        LSLS     R6,R0,#+9
        MOVS     R1,R6
        MOVS     R0,R5
        BL       __Disk_Buff_WR
        ADD      R1,R6,#+256
        ADD      R0,R5,#+256
        BL       __Disk_Buff_WR
        MOVW     R9,#+4087
        MOVW     R6,#+65527
        LDR.N    R7,??DFS_UnlinkFile_2  ;; 0xffffff7
        B.N      ??DFS_UnlinkFile_3
// 1140 		return DFS_ERRMISC;
// 1141 
// 1142 	// Now follow the cluster chain to free the file space
// 1143 	while (!((volinfo->filesystem == FAT12 && fi.firstcluster >= 0x0ff7) ||
// 1144 	  (volinfo->filesystem == FAT16 && fi.firstcluster >= 0xfff7) ||
// 1145 	  (volinfo->filesystem == FAT32 && fi.firstcluster >= 0x0ffffff7))) {
??DFS_UnlinkFile_4:
        LDR      R0,[SP, #+16]
        CMP      R0,R9
        BCS.N    ??DFS_UnlinkFile_5
// 1146 		tempclus = fi.firstcluster;
??DFS_UnlinkFile_6:
        LDR      R3,[SP, #+16]
        MOV      R8,R3
// 1147 
// 1148 		fi.firstcluster = DFS_GetFAT(volinfo, scratch, &cache, fi.firstcluster);
        ADD      R2,SP,#+0
        MOVS     R1,R5
        MOVS     R0,R4
        BL       DFS_GetFAT
        STR      R0,[SP, #+16]
// 1149 		DFS_SetFAT(volinfo, scratch, &cache, tempclus, 0);
        MOVS     R0,#+0
        PUSH     {R0,LR}
        CFI CFA R13+72
        MOV      R3,R8
        ADD      R2,SP,#+8
        MOVS     R1,R5
        MOVS     R0,R4
        BL       DFS_SetFAT
        ADD      SP,SP,#+8
        CFI CFA R13+64
// 1150 
// 1151 	}
??DFS_UnlinkFile_3:
        LDRB     R0,[R4, #+1]
        CMP      R0,#+0
        BEQ.N    ??DFS_UnlinkFile_4
        CMP      R0,#+1
        BNE.N    ??DFS_UnlinkFile_7
        LDR      R0,[SP, #+16]
        CMP      R0,R6
        BCS.N    ??DFS_UnlinkFile_5
        B.N      ??DFS_UnlinkFile_6
??DFS_UnlinkFile_7:
        CMP      R0,#+2
        BNE.N    ??DFS_UnlinkFile_6
        LDR      R0,[SP, #+16]
        CMP      R0,R7
        BCC.N    ??DFS_UnlinkFile_6
// 1152 	return DFS_OK;
??DFS_UnlinkFile_5:
        MOVS     R0,#+0
??DFS_UnlinkFile_1:
        ADD      SP,SP,#+36
        CFI CFA R13+28
        POP      {R4-R9,PC}       ;; return
        DATA
??DFS_UnlinkFile_2:
        DC32     0xffffff7
        CFI EndBlock cfiBlock14
// 1153 }
// 1154 
// 1155 
// 1156 /*
// 1157 	Write an open file
// 1158 	You must supply a prepopulated FILEINFO as provided by DFS_OpenFile, and a
// 1159 	pointer to a SECTOR_SIZE scratch buffer.
// 1160 	This function updates the successcount field with the number of bytes actually written.
// 1161 */

        SECTION `.text`:CODE:NOROOT(2)
        CFI Block cfiBlock15 Using cfiCommon0
        CFI Function DFS_WriteFile
        THUMB
// 1162 uint32_t DFS_WriteFile(PFILEINFO fileinfo, uint8_t *scratch, uint8_t *buffer, uint32_t *successcount, uint32_t len)
// 1163 {
DFS_WriteFile:
        PUSH     {R4-R11,LR}
        CFI R14 Frame(CFA, -4)
        CFI R11 Frame(CFA, -8)
        CFI R10 Frame(CFA, -12)
        CFI R9 Frame(CFA, -16)
        CFI R8 Frame(CFA, -20)
        CFI R7 Frame(CFA, -24)
        CFI R6 Frame(CFA, -28)
        CFI R5 Frame(CFA, -32)
        CFI R4 Frame(CFA, -36)
        CFI CFA R13+36
        SUB      SP,SP,#+28
        CFI CFA R13+64
        MOVS     R4,R0
        MOVS     R5,R1
        MOVS     R6,R2
        MOV      R11,R3
        LDR      R7,[SP, #+64]
// 1164 	uint32_t remain;
// 1165 	uint32_t result = DFS_OK;
// 1166 	uint32_t sector;
// 1167 	uint32_t byteswritten;
// 1168   
// 1169 
// 1170 
// 1171 	// Don't allow writes to a file that's open as readonly
// 1172 	//if (!(fileinfo->mode & DFS_WRITE))
// 1173 		if(fileinfo->mode<DFS_WRITE)
        LDRB     R0,[R4, #+9]
        CMP      R0,#+2
        BCS.N    ??DFS_WriteFile_0
// 1174 		return DFS_ERRMISC;
??DFS_WriteFile_1:
        MOV      R0,#-1
        B.N      ??DFS_WriteFile_2
// 1175 
// 1176 	remain = len;
// 1177 	*successcount = 0;
??DFS_WriteFile_0:
        MOVS     R0,#+0
        STR      R0,[R11, #+0]
        B.N      ??DFS_WriteFile_3
// 1178 
// 1179 	while (remain && result ==DFS_OK) {
// 1180 		// This is a bit complicated. The sector we want to read is addressed at a cluster
// 1181 		// granularity by the fileinfo->cluster member. The file pointer tells us how many
// 1182 		// extra sectors to add to that number.
// 1183 		sector = fileinfo->volinfo->dataarea +
// 1184 		  ((fileinfo->cluster - 2) * fileinfo->volinfo->secperclus*(fileinfo->volinfo->sectorsize/SECTOR_SIZE)) +
// 1185 		  div(div(fileinfo->pointer,fileinfo->volinfo->secperclus*fileinfo->volinfo->sectorsize).rem, SECTOR_SIZE).quot;
// 1186 
// 1187 		// Case 1 - File pointer is not on a sector boundary
// 1188 		if (div(fileinfo->pointer, SECTOR_SIZE).rem) 
// 1189 		{
// 1190 			uint16_t tempsize;
// 1191 
// 1192 			// We always have to go through scratch in this case
// 1193 			result = DFS_ReadSector(fileinfo->volinfo->unit, scratch, sector, 1);
// 1194 
// 1195 			// This is the number of bytes that we don't want to molest in the
// 1196 			// scratch sector just read.
// 1197 			tempsize = div(fileinfo->pointer, SECTOR_SIZE).rem;
// 1198 					
// 1199 			// Case 1A - We are writing the entire remainder of the sector. After
// 1200 			// this point, all passes through the read loop will be aligned on a
// 1201 			// sector boundary, which allows us to go through the optimal path
// 1202 			// 2A below.
// 1203 		   	if (remain >= SECTOR_SIZE - tempsize) {
// 1204 				memcpy(scratch + tempsize, buffer, SECTOR_SIZE - tempsize);
// 1205 				if (!result)
// 1206 					result = DFS_WriteSector(fileinfo->volinfo->unit, scratch, sector, 1);
// 1207 
// 1208 				byteswritten = SECTOR_SIZE - tempsize;
// 1209 				buffer += SECTOR_SIZE - tempsize;
// 1210 				fileinfo->pointer += SECTOR_SIZE - tempsize;
// 1211 				if (fileinfo->filelen < fileinfo->pointer) {
// 1212 					fileinfo->filelen = fileinfo->pointer;
// 1213 				}
// 1214 				remain -= SECTOR_SIZE - tempsize;
// 1215 			}
// 1216 			// Case 1B - This concludes the file write operation
// 1217 			else {
// 1218 				memcpy(scratch + tempsize, buffer, remain);
// 1219 				if (!result)
// 1220 					result = DFS_WriteSector(fileinfo->volinfo->unit, scratch, sector, 1);
// 1221 
// 1222 				buffer += remain;
// 1223 				fileinfo->pointer += remain;
// 1224 				if (fileinfo->filelen < fileinfo->pointer) {
// 1225 					fileinfo->filelen = fileinfo->pointer;
// 1226 				}
// 1227 				byteswritten = remain;
// 1228 				remain = 0;
// 1229 			}
// 1230 		} // case 1
// 1231 		// Case 2 - File pointer is on sector boundary
// 1232 		else 
// 1233 		{
// 1234 			// Case 2A - We have at least one more full sector to write and don't have
// 1235 			// to go through the scratch buffer. You could insert optimizations here to
// 1236 			// write multiple sectors at a time, if you were thus inclined. Refer to
// 1237 			// similar notes in DFS_ReadFile.
// 1238 			if (remain >= SECTOR_SIZE) 
// 1239 			{
// 1240 				result = DFS_WriteSector(fileinfo->volinfo->unit, buffer, sector, 1);
// 1241 				remain -= SECTOR_SIZE;
// 1242 				buffer += SECTOR_SIZE;
// 1243 				fileinfo->pointer += SECTOR_SIZE;
// 1244 				if (fileinfo->filelen < fileinfo->pointer) 
// 1245 				{
// 1246 					fileinfo->filelen = fileinfo->pointer;
// 1247 				}
// 1248 				byteswritten = SECTOR_SIZE;
// 1249 
// 1250 			}
// 1251 			// Case 2B - We are only writing a partial sector and potentially need to
// 1252 			// go through the scratch buffer.
// 1253 			else 
// 1254 			{
// 1255 				// If the current file pointer is not yet at or beyond the file
// 1256 				// length, we are writing somewhere in the middle of the file and
// 1257 				// need to load the original sector to do a read-modify-write.
// 1258 				if (fileinfo->pointer < fileinfo->filelen) 
// 1259 				{
// 1260 					result = DFS_ReadSector(fileinfo->volinfo->unit, scratch, sector, 1);
// 1261 					if (!result) 
// 1262 					{
// 1263 						memcpy(scratch, buffer, remain);
// 1264 						result = DFS_WriteSector(fileinfo->volinfo->unit, scratch, sector, 1);
// 1265 					}
// 1266 				}
// 1267 				else
// 1268 			 {
// 1269 					result = DFS_WriteSector(fileinfo->volinfo->unit, buffer, sector, 1);
// 1270 				}
// 1271 
// 1272 				buffer += remain;
// 1273 				fileinfo->pointer += remain;
// 1274 				if (fileinfo->filelen < fileinfo->pointer) {
// 1275 					fileinfo->filelen = fileinfo->pointer;
// 1276 				}
// 1277 				byteswritten = remain;
// 1278 				remain = 0;
// 1279 			}
// 1280 		}
// 1281 
// 1282 		*successcount += byteswritten;
// 1283 
// 1284 		// check to see if we stepped over a cluster boundary*fileinfo->volinfo->sectorsize
// 1285 		if (div(fileinfo->pointer - byteswritten, fileinfo->volinfo->secperclus*fileinfo->volinfo->sectorsize).quot !=
// 1286 		  div(fileinfo->pointer, fileinfo->volinfo->secperclus* fileinfo->volinfo->sectorsize ).quot) 
// 1287 		{
// 1288 		  	uint32_t lastcluster;
// 1289 
// 1290 		  	// We've transgressed into another cluster. If we were already at EOF,
// 1291 		  	// we need to allocate a new cluster.
// 1292 			// An act of minor evil - we use byteswritten as a scratch integer, knowing
// 1293 			// that its value is not used after updating *successcount above
// 1294 			byteswritten = 0;
// 1295 
// 1296 			lastcluster = fileinfo->cluster;
// 1297 			fileinfo->cluster = DFS_GetFAT(fileinfo->volinfo, scratch, &byteswritten, fileinfo->cluster);//
// 1298 			if(fileinfo->mode==DFS_WRITE)
// 1299 			{
// 1300 				// Allocate a new cluster?
// 1301 				if (((fileinfo->volinfo->filesystem == FAT12) && (fileinfo->cluster >= 0xff8)) ||
// 1302 				  ((fileinfo->volinfo->filesystem == FAT16) && (fileinfo->cluster >= 0xfff8)) ||
// 1303 				  ((fileinfo->volinfo->filesystem == FAT32) && (fileinfo->cluster >= 0x0ffffff8)))
// 1304 				 {
// 1305 				  	uint32_t tempclus;
// 1306 	
// 1307 					tempclus = DFS_GetFreeFAT(fileinfo->volinfo, scratch);
// 1308 					byteswritten = 0; // invalidate cache
// 1309 					if (tempclus == 0x0ffffff7)
// 1310 						return DFS_ERRMISC;
// 1311 	
// 1312 					// Link new cluster onto file
// 1313 					DFS_SetFAT(fileinfo->volinfo, scratch, &byteswritten, lastcluster, tempclus);
// 1314 					fileinfo->cluster = tempclus;
// 1315 	
// 1316 					// Mark newly allocated cluster as end of chain			
// 1317 					switch(fileinfo->volinfo->filesystem) 
// 1318 				{
// 1319 						case FAT12:		tempclus = 0xff8;	break;
// 1320 						case FAT16:		tempclus = 0xfff8;	break;
// 1321 						case FAT32:		tempclus = 0x0ffffff8;	break;
??DFS_WriteFile_4:
        LDR.W    R8,??DFS_WriteFile_5  ;; 0xffffff8
// 1322 						default:		return DFS_ERRMISC;
// 1323 					}
// 1324 					DFS_SetFAT(fileinfo->volinfo, scratch, &byteswritten, fileinfo->cluster, tempclus);
??DFS_WriteFile_6:
        PUSH     {R8,LR}
        CFI CFA R13+72
        LDR      R3,[R4, #+20]
        ADD      R2,SP,#+8
        MOVS     R1,R5
        BL       DFS_SetFAT
        ADD      SP,SP,#+8
        CFI CFA R13+64
// 1325 		
// 1326 					result = DFS_OK;
??DFS_WriteFile_3:
        CMP      R7,#+0
        BEQ.W    ??DFS_WriteFile_7
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+20]
        LDRH     R0,[R0, #+52]
        MUL      R2,R1,R0
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+12
        BL       div
        MOV      R2,#+512
        LDR      R1,[SP, #+16]
        ADD      R0,SP,#+4
        BL       div
        LDR      R0,[R4, #+0]
        LDR      R1,[R0, #+48]
        LDR      R2,[R4, #+20]
        SUBS     R2,R2,#+2
        LDRB     R3,[R0, #+20]
        MULS     R2,R2,R3
        LDRH     R0,[R0, #+52]
        LSRS     R0,R0,#+9
        MLA      R0,R2,R0,R1
        LDR      R1,[SP, #+4]
        ADD      R8,R1,R0
        MOV      R2,#+512
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+4
        BL       div
        LSL      R8,R8,#+9
        LDR      R0,[SP, #+8]
        CMP      R0,#+0
        BEQ.W    ??DFS_WriteFile_8
        MOV      R2,#+512
        MOV      R1,R8
        MOVS     R0,R5
        BL       __Disk_Buff_RD
        MOV      R2,#+512
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+4
        BL       div
        LDR      R10,[SP, #+8]
        UXTH     R10,R10
        RSB      R9,R10,#+512
        ADD      R0,R10,R5
        CMP      R7,R9
        BCC.N    ??DFS_WriteFile_9
        MOV      R2,R9
        MOVS     R1,R6
        BL       __aeabi_memcpy
        MOV      R1,R8
        MOVS     R0,R5
        BL       __Disk_Buff_WR
        ADD      R1,R8,#+256
        ADD      R0,R5,#+256
        BL       __Disk_Buff_WR
        STR      R9,[SP, #+0]
        RSB      R0,R10,#+0
        ADDS     R0,R0,R6
        ADD      R6,R0,#+512
        LDR      R0,[R4, #+24]
        ADD      R0,R9,R0
        STR      R0,[R4, #+24]
        LDR      R1,[R4, #+16]
        CMP      R1,R0
        IT       CC 
        STRCC    R0,[R4, #+16]
        SUB      R7,R7,R9
??DFS_WriteFile_10:
        LDR      R0,[R11, #+0]
        LDR      R1,[SP, #+0]
        ADDS     R0,R1,R0
        STR      R0,[R11, #+0]
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+20]
        LDRH     R0,[R0, #+52]
        MUL      R2,R1,R0
        LDR      R0,[R4, #+24]
        LDR      R1,[SP, #+0]
        SUBS     R1,R0,R1
        ADD      R0,SP,#+4
        BL       div
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+20]
        LDRH     R0,[R0, #+52]
        MUL      R2,R1,R0
        LDR      R1,[R4, #+24]
        ADD      R0,SP,#+12
        BL       div
        LDR      R0,[SP, #+4]
        LDR      R1,[SP, #+12]
        CMP      R0,R1
        BEQ.N    ??DFS_WriteFile_3
        MOVS     R0,#+0
        STR      R0,[SP, #+0]
        LDR      R3,[R4, #+20]
        MOV      R10,R3
        ADD      R2,SP,#+0
        MOVS     R1,R5
        LDR      R0,[R4, #+0]
        BL       DFS_GetFAT
        STR      R0,[R4, #+20]
        LDRB     R0,[R4, #+9]
        CMP      R0,#+2
        BNE.W    ??DFS_WriteFile_3
        LDR      R9,[R4, #+0]
        LDRB     R0,[R9, #+1]
        CBNZ     R0,??DFS_WriteFile_11
        LDR      R0,[R4, #+20]
        MOVW     R1,#+4088
        CMP      R0,R1
        BCS.N    ??DFS_WriteFile_12
??DFS_WriteFile_11:
        LDRB     R0,[R9, #+1]
        CMP      R0,#+1
        BNE.N    ??DFS_WriteFile_13
        LDR      R0,[R4, #+20]
        MOVW     R1,#+65528
        CMP      R0,R1
        BCS.N    ??DFS_WriteFile_12
??DFS_WriteFile_13:
        LDRB     R0,[R9, #+1]
        CMP      R0,#+2
        BNE.W    ??DFS_WriteFile_3
        LDR      R0,[R4, #+20]
        LDR.N    R1,??DFS_WriteFile_5  ;; 0xffffff8
        CMP      R0,R1
        BCC.W    ??DFS_WriteFile_3
??DFS_WriteFile_12:
        MOVS     R0,#+0
        STR      R0,[SP, #+20]
        MOV      R8,#+2
        B.N      ??DFS_WriteFile_14
??DFS_WriteFile_9:
        MOVS     R2,R7
        MOVS     R1,R6
        BL       __aeabi_memcpy
        MOV      R1,R8
        MOVS     R0,R5
        BL       __Disk_Buff_WR
        ADD      R1,R8,#+256
        ADD      R0,R5,#+256
        BL       __Disk_Buff_WR
        ADDS     R6,R7,R6
        LDR      R0,[R4, #+24]
        ADDS     R0,R7,R0
        STR      R0,[R4, #+24]
        LDR      R1,[R4, #+16]
        CMP      R1,R0
        IT       CC 
        STRCC    R0,[R4, #+16]
??DFS_WriteFile_15:
        STR      R7,[SP, #+0]
        MOVS     R7,#+0
        B.N      ??DFS_WriteFile_10
??DFS_WriteFile_8:
        CMP      R7,#+512
        BCC.N    ??DFS_WriteFile_16
        MOV      R1,R8
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R8,#+256
        ADD      R0,R6,#+256
        BL       __Disk_Buff_WR
        SUB      R7,R7,#+512
        ADD      R6,R6,#+512
        LDR      R0,[R4, #+24]
        ADD      R0,R0,#+512
        STR      R0,[R4, #+24]
        LDR      R1,[R4, #+16]
        CMP      R1,R0
        IT       CC 
        STRCC    R0,[R4, #+16]
        MOV      R0,#+512
        STR      R0,[SP, #+0]
        B.N      ??DFS_WriteFile_10
??DFS_WriteFile_16:
        LDR      R0,[R4, #+24]
        LDR      R1,[R4, #+16]
        CMP      R0,R1
        BCS.N    ??DFS_WriteFile_17
        MOV      R2,#+512
        MOV      R1,R8
        MOVS     R0,R5
        BL       __Disk_Buff_RD
        MOVS     R2,R7
        MOVS     R1,R6
        MOVS     R0,R5
        BL       __aeabi_memcpy
        MOV      R1,R8
        MOVS     R0,R5
        BL       __Disk_Buff_WR
        ADD      R1,R8,#+256
        ADD      R0,R5,#+256
        B.N      ??DFS_WriteFile_18
??DFS_WriteFile_17:
        MOV      R1,R8
        MOVS     R0,R6
        BL       __Disk_Buff_WR
        ADD      R1,R8,#+256
        ADD      R0,R6,#+256
??DFS_WriteFile_18:
        BL       __Disk_Buff_WR
        ADDS     R6,R7,R6
        LDR      R0,[R4, #+24]
        ADDS     R0,R7,R0
        STR      R0,[R4, #+24]
        LDR      R1,[R4, #+16]
        CMP      R1,R0
        BCS.N    ??DFS_WriteFile_15
        STR      R0,[R4, #+16]
        B.N      ??DFS_WriteFile_15
??DFS_WriteFile_19:
        ADD      R8,R8,#+1
??DFS_WriteFile_14:
        LDR      R0,[R9, #+36]
        CMP      R8,R0
        BCS.N    ??DFS_WriteFile_20
        MOV      R3,R8
        ADD      R2,SP,#+20
        MOVS     R1,R5
        MOV      R0,R9
        BL       DFS_GetFAT
        CMP      R0,#+0
        BNE.N    ??DFS_WriteFile_19
        B.N      ??DFS_WriteFile_21
??DFS_WriteFile_20:
        LDR.W    R8,??DFS_WriteFile_5+0x4  ;; 0xffffff7
??DFS_WriteFile_21:
        MOVS     R0,#+0
        STR      R0,[SP, #+0]
        LDR.N    R0,??DFS_WriteFile_5+0x4  ;; 0xffffff7
        CMP      R8,R0
        BEQ.W    ??DFS_WriteFile_1
        PUSH     {R8,LR}
        CFI CFA R13+72
        MOV      R3,R10
        ADD      R2,SP,#+8
        MOVS     R1,R5
        LDR      R0,[R4, #+0]
        BL       DFS_SetFAT
        ADD      SP,SP,#+8
        CFI CFA R13+64
        STR      R8,[R4, #+20]
        LDR      R0,[R4, #+0]
        LDRB     R1,[R0, #+1]
        CBZ      R1,??DFS_WriteFile_22
        CMP      R1,#+1
        BEQ.N    ??DFS_WriteFile_23
        CMP      R1,#+2
        BEQ.W    ??DFS_WriteFile_4
        B.N      ??DFS_WriteFile_1
??DFS_WriteFile_22:
        MOVW     R8,#+4088
        B.N      ??DFS_WriteFile_6
??DFS_WriteFile_23:
        MOVW     R8,#+65528
        B.N      ??DFS_WriteFile_6
// 1327 				}
// 1328 				else 
// 1329 					result = DFS_OK;
// 1330 				}
// 1331 			// No else clause is required.
// 1332 		}
// 1333 	};//while end
// 1334 
// 1335 
// 1336 		if (DFS_ReadSector(fileinfo->volinfo->unit, scratch, fileinfo->dirsector, 1))
??DFS_WriteFile_7:
        MOV      R2,#+512
        LDR      R0,[R4, #+4]
        LSLS     R1,R0,#+9
        MOVS     R0,R5
        BL       __Disk_Buff_RD
// 1337 			return DFS_ERRMISC;
// 1338 
// 1339 		((PDIRENT) scratch)[fileinfo->diroffset].filesize_0 = fileinfo->filelen & 0xff;
        LDRB     R0,[R4, #+8]
        ADD      R0,R5,R0, LSL #+5
        LDR      R1,[R4, #+16]
        STRB     R1,[R0, #+28]
// 1340 		((PDIRENT) scratch)[fileinfo->diroffset].filesize_1 = (fileinfo->filelen & 0xff00) >> 8;
        LDRB     R0,[R4, #+8]
        ADD      R0,R5,R0, LSL #+5
        LDR      R1,[R4, #+16]
        LSRS     R1,R1,#+8
        STRB     R1,[R0, #+29]
// 1341 		((PDIRENT) scratch)[fileinfo->diroffset].filesize_2 = (fileinfo->filelen & 0xff0000) >> 16;
        LDRB     R0,[R4, #+8]
        ADD      R0,R5,R0, LSL #+5
        LDR      R1,[R4, #+16]
        LSRS     R1,R1,#+16
        STRB     R1,[R0, #+30]
// 1342 		((PDIRENT) scratch)[fileinfo->diroffset].filesize_3 = (fileinfo->filelen & 0xff000000) >> 24;
        LDRB     R0,[R4, #+8]
        ADD      R0,R5,R0, LSL #+5
        LDR      R1,[R4, #+16]
        LSRS     R1,R1,#+24
        STRB     R1,[R0, #+31]
// 1343 		if (DFS_WriteSector(fileinfo->volinfo->unit, scratch, fileinfo->dirsector, 1))
        LDR      R0,[R4, #+4]
        LSLS     R4,R0,#+9
        MOVS     R1,R4
        MOVS     R0,R5
        BL       __Disk_Buff_WR
        ADD      R1,R4,#+256
        ADD      R0,R5,#+256
        BL       __Disk_Buff_WR
// 1344 			return DFS_ERRMISC;
// 1345 
// 1346 	return result;
        MOVS     R0,#+0
??DFS_WriteFile_2:
        ADD      SP,SP,#+28
        CFI CFA R13+36
        POP      {R4-R11,PC}      ;; return
        Nop      
        DATA
??DFS_WriteFile_5:
        DC32     0xffffff8
        DC32     0xffffff7
        CFI EndBlock cfiBlock15
// 1347 }

        END
// 1348 
// 
// 4 762 bytes in section .text
// 
// 4 762 bytes of CODE memory
//
//Errors: none
//Warnings: none
